/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import xyz.tcheeric.wallet.core.SendService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.proof.ProofRecord;
import xyz.tcheeric.wallet.core.token.TokenCodec;
import xyz.tcheeric.wallet.core.token.TokenEnvelope;

@CommandLine.Command(name="export-token", description={"Export proofs as a Cashu token string for transfer or backup"})
public class ExportTokenCmd
implements Callable<Integer> {
    private final SendService sendService;
    private final TokenCodec tokenCodec;
    @CommandLine.Option(names={"--amount"}, required=true, description={"Amount to export (in smallest unit)"})
    private long amount;
    @CommandLine.Option(names={"--unit"}, defaultValue="sat", description={"Currency unit (default: sat)"})
    private String unit;
    @CommandLine.Option(names={"--mint"}, description={"Mint URL (default: from wallet config)"})
    private String mint;

    public ExportTokenCmd(SendService sendService, TokenCodec tokenCodec) {
        this.sendService = Objects.requireNonNull(sendService, "sendService");
        this.tokenCodec = Objects.requireNonNull(tokenCodec, "tokenCodec");
    }

    @Override
    public Integer call() {
        try {
            WalletConfig config = WalletConfig.load();
            String mintUrl = this.resolveOrDefault(this.mint, config.defaultMintUrl());
            String resolvedUnit = this.resolveOrDefault(this.unit, config.defaultUnit());
            if (mintUrl == null || mintUrl.isBlank()) {
                System.err.println("Error: No mint URL specified. Use --mint or configure a default mint.");
                return 1;
            }
            WalletConfig flowConfig = new WalletConfig(mintUrl, resolvedUnit);
            this.sendService.init(flowConfig);
            SendService.PreparedP2pkSend prepared = this.sendService.prepareP2pkSend(new SendService.P2pkSendRequest(this.amount, resolvedUnit, mintUrl));
            List<ProofRecord> proofs = prepared.proofs();
            List<TokenEnvelope.TokenProof> tokenProofs = proofs.stream().map(proof -> new TokenEnvelope.TokenProof(proof.amount(), proof.cHex(), proof.secret(), proof.keysetId())).toList();
            TokenEnvelope envelope = new TokenEnvelope(mintUrl, resolvedUnit, tokenProofs);
            String token = this.tokenCodec.encode(envelope);
            prepared.commit();
            System.out.println(token);
            return 0;
        }
        catch (IllegalStateException e) {
            System.err.println("Error: " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.err.println("Error exporting token: " + e.getMessage());
            if (Boolean.getBoolean("DEBUG")) {
                e.printStackTrace(System.err);
            }
            return 1;
        }
    }

    private String resolveOrDefault(String provided, String defaultValue) {
        return provided != null && !provided.isBlank() ? provided : defaultValue;
    }
}

