/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import picocli.CommandLine;
import xyz.tcheeric.bips.bip39.Bip39;
import xyz.tcheeric.wallet.cli.WalletMain;
import xyz.tcheeric.wallet.cli.mnemonic.MnemonicStorageService;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.H2WalletService;
import xyz.tcheeric.wallet.core.H2WalletStorageAdapter;
import xyz.tcheeric.wallet.core.ports.WalletStorage;
import xyz.tcheeric.wallet.core.state.WalletState;
import xyz.tcheeric.wallet.storage.file.FileWalletStorage;

@CommandLine.Command(name="generate-mnemonic", description={"Generate a new BIP39 mnemonic phrase for wallet recovery"}, mixinStandardHelpOptions=true)
public class GenerateMnemonicCmd
implements Runnable {
    @CommandLine.ParentCommand
    WalletMain parent;
    private static final int DEFAULT_WORD_COUNT = 12;
    @CommandLine.Option(names={"-w", "--words"}, description={"Number of words (12, 15, 18, 21, 24). Default: ${DEFAULT-VALUE}"}, defaultValue="12")
    private int wordCount = 12;
    @CommandLine.Option(names={"-s", "--show-entropy"}, description={"Show entropy used for generation (for debugging)"})
    private boolean showEntropy;
    @CommandLine.Option(names={"--store-mnemonic"}, description={"Encrypt and store the generated mnemonic in wallet state"})
    boolean storeMnemonic;
    @CommandLine.Option(names={"--store-passphrase"}, description={"Passphrase used to encrypt mnemonic when storing"}, interactive=true, arity="0..1")
    String storePassphrase;
    private static final String DEFAULT_WALLET_ID = "default";
    private final BalanceService service;
    private final MnemonicStorageService mnemonicStorageService;
    private final WalletStorage overrideWalletStorage;

    public GenerateMnemonicCmd(BalanceService service) {
        this(service, new MnemonicStorageService(), null);
    }

    public GenerateMnemonicCmd() {
        this(null, new MnemonicStorageService(), null);
    }

    GenerateMnemonicCmd(BalanceService service, MnemonicStorageService mnemonicStorageService, WalletStorage overrideWalletStorage) {
        this.service = service;
        this.mnemonicStorageService = mnemonicStorageService;
        this.overrideWalletStorage = overrideWalletStorage;
    }

    @Override
    public void run() {
        block6: {
            try {
                int effectiveWordCount = this.resolveWordCount();
                if (!this.isValidWordCount(effectiveWordCount)) {
                    System.err.println("Invalid word count: " + effectiveWordCount);
                    System.err.println("Valid word counts: 12, 15, 18, 21, 24");
                    return;
                }
                this.wordCount = effectiveWordCount;
                String mnemonic = Bip39.generateMnemonic(effectiveWordCount);
                if (this.parent != null && this.parent.jsonOutput) {
                    System.out.println("{\"mnemonic\":\"" + mnemonic + "\",\"wordCount\":" + effectiveWordCount + "}");
                } else {
                    this.displayMnemonic(mnemonic);
                }
                if (this.storeMnemonic) {
                    this.storeGeneratedMnemonic(mnemonic);
                }
            }
            catch (Exception e) {
                System.err.println("Failed to generate mnemonic: " + e.getMessage());
                if (!this.showEntropy) break block6;
                e.printStackTrace();
            }
        }
    }

    private void displayMnemonic(String mnemonic) {
        System.out.println();
        System.out.println("Generated BIP39 Mnemonic:");
        System.out.println("\u2501".repeat(60));
        System.out.println(mnemonic);
        System.out.println("\u2501".repeat(60));
        System.out.println();
        System.out.println("\u26a0\ufe0f  SECURITY WARNING:");
        System.out.println("   \u2022 Write down this phrase on paper");
        System.out.println("   \u2022 Never store it digitally unencrypted");
        System.out.println("   \u2022 Keep it in a secure location");
        System.out.println("   \u2022 Anyone with this phrase can access your wallet");
        System.out.println();
    }

    private boolean isValidWordCount(int count) {
        return count == 12 || count == 15 || count == 18 || count == 21 || count == 24;
    }

    private int resolveWordCount() {
        return this.wordCount <= 0 ? 12 : this.wordCount;
    }

    GenerateMnemonicCmd withWordCount(int override) {
        this.wordCount = override;
        return this;
    }

    private void storeGeneratedMnemonic(String mnemonic) {
        if (this.storePassphrase == null || this.storePassphrase.isEmpty()) {
            System.err.println("\n\u274c Passphrase required for --store-mnemonic");
            System.err.println("Suggestion: Provide --store-passphrase to encrypt the mnemonic before storing.");
            return;
        }
        try {
            WalletStorage storage = this.resolveWalletStorage();
            WalletState state = storage.load(DEFAULT_WALLET_ID).orElseThrow(() -> new IllegalStateException("Wallet state not initialized. Suggestion: Run `wallet init` first."));
            WalletState updated = this.mnemonicStorageService.storeMnemonic(state, mnemonic, this.storePassphrase);
            storage.save(DEFAULT_WALLET_ID, updated);
            System.out.println("Mnemonic encrypted and stored in wallet state.");
        }
        catch (Exception e) {
            System.err.println("Failed to store mnemonic: " + e.getMessage());
        }
    }

    private WalletStorage resolveWalletStorage() {
        if (this.overrideWalletStorage != null) {
            return this.overrideWalletStorage;
        }
        BalanceService balanceService = this.service;
        if (balanceService instanceof H2WalletService) {
            H2WalletService h2 = (H2WalletService)balanceService;
            return new H2WalletStorageAdapter(h2.getDataSource());
        }
        return new FileWalletStorage();
    }
}

