/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.WalletMain;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.api.MintApi;
import xyz.tcheeric.wallet.core.api.MintApiMapper;
import xyz.tcheeric.wallet.core.api.MintInfoCache;
import xyz.tcheeric.wallet.core.api.adapter.CashuWalletMintApi;
import xyz.tcheeric.wallet.core.api.adapter.RestTemplateFactory;

@CommandLine.Command(name="info", description={"Fetch mint /v1/info"})
public class InfoCmd
extends WalletServiceCommand<BalanceService> {
    @CommandLine.ParentCommand
    WalletMain parent;
    @CommandLine.Option(names={"--mint"}, description={"Mint base URL"})
    String mint;
    @CommandLine.Option(names={"--refresh-cache"}, description={"Fetch fresh /v1/info and update local cache"})
    boolean refreshCache;
    @CommandLine.Option(names={"--cached"}, description={"Print cached /v1/info without network (if available)"})
    boolean cached;

    public InfoCmd(BalanceService service) {
        super(service);
    }

    @Override
    public void run() {
        CashuWalletMintApi api = new CashuWalletMintApi(RestTemplateFactory.create());
        String mintUrl = this.mint != null ? this.mint : WalletConfig.load().defaultMintUrl();
        try {
            if (this.cached && !this.refreshCache) {
                String cachedJson = MintInfoCache.load(mintUrl);
                if (cachedJson == null) {
                    throw new CommandLine.ExecutionException(new CommandLine(this), "No cached /v1/info present. Cache is empty for this mint URL. Suggestion: Run without --cached to fetch live info, or use --refresh-cache to update the cache.");
                }
                MintApiMapper mapper = new MintApiMapper();
                MintApi.MintInfo info = mapper.parseMintInfo(mintUrl, cachedJson);
                this.printInfo(info);
                return;
            }
            MintApi.MintInfo info = api.info(mintUrl);
            this.printInfo(info);
        }
        catch (Exception e) {
            System.err.println("Error fetching mint info: " + e.getMessage());
        }
    }

    private void printInfo(MintApi.MintInfo info) {
        if (this.parent != null && this.parent.jsonOutput) {
            System.out.println("{\"mint\":\"" + info.url() + "\",\"units\":[\"" + String.join((CharSequence)"\",\"", info.units()) + "\"],\"mintMethods\":[\"" + String.join((CharSequence)"\",\"", info.mintMethods()) + "\"],\"meltMethods\":[\"" + String.join((CharSequence)"\",\"", info.meltMethods()) + "\"]}");
        } else {
            System.out.println("Mint: " + info.url());
            System.out.println("Units: " + String.join((CharSequence)", ", info.units()));
            if (info.mintMethods() != null && !info.mintMethods().isEmpty()) {
                System.out.println("Mint methods: " + String.join((CharSequence)", ", info.mintMethods()));
            }
            if (info.meltMethods() != null && !info.meltMethods().isEmpty()) {
                System.out.println("Melt methods: " + String.join((CharSequence)", ", info.meltMethods()));
            }
        }
    }
}

