/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import xyz.tcheeric.bips.bip39.Bip39;
import xyz.tcheeric.bips.bip39.MnemonicValidator;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.cli.mnemonic.MnemonicStorageService;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.WalletServices;

@CommandLine.Command(name="init", description={"Initialize wallet profile (random or deterministic)"}, mixinStandardHelpOptions=true)
public class Init
extends WalletServiceCommand<BalanceService> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Init.class);
    @CommandLine.Option(names={"--mint"}, description={"Mint base URL"})
    String mint;
    @CommandLine.Option(names={"--unit"}, description={"Default unit (e.g., sat)"})
    String unit;
    @CommandLine.Option(names={"--deterministic"}, description={"Initialize deterministic wallet with BIP39 mnemonic"})
    boolean deterministic;
    @CommandLine.Option(names={"--mnemonic"}, description={"BIP39 mnemonic phrase (12-24 words). If not provided, generates new mnemonic."}, interactive=true, arity="0..1")
    String mnemonic;
    @CommandLine.Option(names={"-p", "--passphrase"}, description={"Passphrase for mnemonic encryption (required for --deterministic)"}, interactive=true, arity="0..1")
    String passphrase;
    private final MnemonicStorageService mnemonicStorageService;

    public Init(BalanceService service, MnemonicStorageService mnemonicStorageService) {
        super(service);
        this.mnemonicStorageService = mnemonicStorageService;
    }

    public Init() {
        super(WalletServices.createDefault());
        this.mnemonicStorageService = new MnemonicStorageService();
    }

    @Override
    public void run() {
        try {
            WalletConfig src = WalletConfig.load();
            String mintUrl = this.mint != null ? this.mint : src.defaultMintUrl();
            String u = this.unit != null ? this.unit : src.defaultUnit();
            this.service.init(new WalletConfig(mintUrl, u));
            log.info("wallet_init_started deterministic={} mint={} unit={}", this.deterministic, mintUrl, u);
            if (this.deterministic) {
                this.handleDeterministicInit();
            } else {
                this.handleRandomInit();
            }
            System.out.println("Initialized wallet profile");
            System.out.println("  mint: " + mintUrl);
            System.out.println("  unit: " + u);
            System.out.println("  mode: " + (this.deterministic ? "deterministic (BIP39)" : "random"));
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    private void handleDeterministicInit() throws Exception {
        String actualMnemonic;
        log.debug("deterministic_init_started mnemonic_provided={}", (Object)(this.mnemonic != null ? 1 : 0));
        if (this.passphrase == null || this.passphrase.isEmpty()) {
            System.err.println("\n\u274c Passphrase required for deterministic wallet");
            System.err.println("Suggestion: Use --passphrase to provide encryption passphrase");
            log.error("deterministic_init_failed reason=missing_passphrase");
            throw new IllegalArgumentException("Passphrase required for deterministic wallet initialization");
        }
        if (this.mnemonic == null || this.mnemonic.trim().isEmpty()) {
            actualMnemonic = Bip39.generateMnemonic(12);
            log.info("mnemonic_generated word_count=12");
            this.displayGeneratedMnemonic(actualMnemonic);
        } else {
            actualMnemonic = this.mnemonic.trim().replaceAll("\\s+", " ");
            log.debug("mnemonic_provided word_count={}", (Object)actualMnemonic.split("\\s+").length);
        }
        MnemonicValidator.ValidationResult validation = Bip39.validateMnemonic(actualMnemonic);
        if (!validation.isValid()) {
            System.err.println("\n\u274c Invalid mnemonic: " + validation.getErrorMessage());
            System.err.println("Suggestion: Verify the mnemonic was copied correctly and contains valid BIP39 words");
            log.error("deterministic_init_failed reason=invalid_mnemonic error={}", (Object)validation.getErrorMessage());
            throw new IllegalArgumentException("Invalid BIP39 mnemonic: " + validation.getErrorMessage());
        }
        log.info("mnemonic_validated word_count={}", (Object)actualMnemonic.split("\\s+").length);
        System.err.println("\n\u26a0\ufe0f  Deterministic wallet initialization available but wallet state persistence pending.");
        System.err.println("\nTask 6.5 & 6.6 components ready:");
        System.err.println("  \u2713 BIP39 mnemonic generation and validation");
        System.err.println("  \u2713 AES-256-GCM encryption (MnemonicStorageService)");
        System.err.println("  \u2713 WalletState mnemonic fields");
        System.err.println("\nPending: CLI wallet state load/save integration");
        System.err.println("Suggestion: Keep the mnemonic phrase secure until persistence is implemented.");
        log.warn("deterministic_init_partial reason=wallet_state_persistence_pending");
    }

    private void handleRandomInit() {
        log.info("random_init_completed");
    }

    private void displayGeneratedMnemonic(String generatedMnemonic) {
        System.out.println("\n\ud83d\udcdd Generated new BIP39 mnemonic:");
        System.out.println("\u2501".repeat(80));
        System.out.println(generatedMnemonic);
        System.out.println("\u2501".repeat(80));
        System.out.println("\n\u26a0\ufe0f  SECURITY WARNING:");
        System.out.println("   \u2022 Write down this phrase on paper and store securely");
        System.out.println("   \u2022 Never store it digitally unencrypted");
        System.out.println("   \u2022 Anyone with this phrase can access your wallet");
        System.out.println("   \u2022 Loss of this phrase means permanent loss of funds");
        System.out.println();
    }

    private void handleError(Exception e) {
        System.err.println("\n\u274c Wallet initialization failed: " + e.getMessage());
        System.err.println("Suggestion: Check the error message above and verify your inputs");
        log.error("wallet_init_failed error={}", (Object)e.getMessage(), (Object)e);
    }
}

