/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.CliUtils;
import xyz.tcheeric.wallet.cli.WalletMain;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.H2WalletService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.proof.ProofSummary;

@CommandLine.Command(name="list-proofs", description={"List proofs with optional filters (amount range, keyset, include spent). Supports --detail and --json. Requires H2 backend."})
public class ListProofsCmd
extends WalletServiceCommand<BalanceService> {
    @CommandLine.ParentCommand
    WalletMain parent;
    @CommandLine.Option(names={"--mint"}, description={"Mint base URL"})
    String mint;
    @CommandLine.Option(names={"--unit"}, description={"Unit"}, required=true)
    String unit;
    @CommandLine.Option(names={"--limit"}, description={"Max rows to list (default 50)"})
    int limit = 50;
    @CommandLine.Option(names={"--min"}, description={"Min amount filter"})
    Integer minAmount;
    @CommandLine.Option(names={"--max"}, description={"Max amount filter"})
    Integer maxAmount;
    @CommandLine.Option(names={"--keyset"}, description={"Filter by keyset id (64 lowercase hex)"})
    String keyset;
    @CommandLine.Option(names={"--spent"}, description={"Include spent proofs"})
    boolean includeSpent;
    @CommandLine.Option(names={"--detail"}, description={"Show full C and timestamp"})
    boolean detail;

    public ListProofsCmd(BalanceService service) {
        super(service);
    }

    @Override
    public void run() {
        BalanceService balanceService;
        WalletConfig config = WalletConfig.load();
        String mintUrl = this.mint != null ? this.mint : config.defaultMintUrl();
        this.service.init(new WalletConfig(mintUrl, this.unit));
        if (this.keyset != null) {
            this.keyset = CliUtils.normalizeKeysetId(this.keyset);
        }
        if (!((balanceService = this.service) instanceof H2WalletService)) {
            throw new CommandLine.ExecutionException(new CommandLine(this), "H2 backend required. WALLET_STORAGE must be set to 'h2'. Suggestion: Export WALLET_STORAGE=h2 and retry.");
        }
        H2WalletService h2Service = (H2WalletService)balanceService;
        List<ProofSummary> list = this.fetchProofSummaries(h2Service, mintUrl);
        if (this.parent != null && this.parent.jsonOutput) {
            try {
                System.out.println(new ObjectMapper().writeValueAsString(list));
            }
            catch (JsonProcessingException e) {
                throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to serialize proof summaries. JSON processing error: " + e.getOriginalMessage() + ". Suggestion: Re-run without --json or file an issue with the output details.", e);
            }
        } else {
            this.printProofSummariesPlain(list);
        }
    }

    private List<ProofSummary> fetchProofSummaries(H2WalletService h2Service, String mintUrl) {
        return h2Service.listProofSummaries(this.unit, mintUrl, this.minAmount, this.maxAmount, this.keyset, this.includeSpent, this.limit);
    }

    private void printProofSummariesPlain(List<ProofSummary> list) {
        for (ProofSummary p : list) {
            String cShown = this.detail ? p.cHex() : (p.cHex().length() > 16 ? p.cHex().substring(0, 16) + "\u2026" : p.cHex());
            String ts = p.createdAt() == null ? "" : " | created=" + String.valueOf(p.createdAt());
            String sp = p.spent() ? " | spent" : "";
            System.out.println(p.amount() + " | keyset=" + p.keysetId() + " | C=" + cShown + sp + ts);
        }
    }
}

