/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.CliUtils;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.MeltRequestContext;
import xyz.tcheeric.wallet.core.MeltService;
import xyz.tcheeric.wallet.core.WalletConfig;

@CommandLine.Command(name="melt", description={"Pay a BOLT11 invoice using tokens. Performs exact selection or swaps to exact and keeps change. Requires H2 backend."})
public class MeltCmd
extends WalletServiceCommand<MeltService> {
    @CommandLine.Option(names={"--mint"}, description={"Mint base URL"})
    String mint;
    @CommandLine.Option(names={"--unit"}, description={"Unit"}, required=true)
    String unit;
    @CommandLine.Option(names={"--amount"}, description={"Amount"}, required=true)
    long amount;
    @CommandLine.Option(names={"--invoice"}, description={"BOLT11 invoice"}, required=true)
    String invoice;

    public MeltCmd(MeltService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        String mintUrl = this.mint != null ? this.mint : config.defaultMintUrl();
        CliUtils.ensureH2Backend();
        ((MeltService)this.service).init(new WalletConfig(mintUrl, this.unit));
        ((MeltService)this.service).melt(new MeltRequestContext(this.amount, this.unit, this.invoice, mintUrl));
        System.out.println("Melted " + this.amount + " " + this.unit + " on " + mintUrl);
    }
}

