/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.WalletMain;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.api.MintApi;
import xyz.tcheeric.wallet.core.api.MintApiException;
import xyz.tcheeric.wallet.core.api.adapter.CashuWalletMintApi;
import xyz.tcheeric.wallet.core.api.adapter.RestTemplateFactory;

@CommandLine.Command(name="melt-quote", description={"Request a melt quote"})
public class MeltQuoteCmd
extends WalletServiceCommand<BalanceService> {
    @CommandLine.ParentCommand
    WalletMain parent;
    @CommandLine.Option(names={"--mint"}, description={"Mint base URL"})
    String mint;
    @CommandLine.Option(names={"--unit"}, description={"Unit"}, required=true)
    String unit;
    @CommandLine.Option(names={"--amount"}, description={"Amount"}, required=true)
    long amount;
    @CommandLine.Option(names={"--invoice"}, description={"BOLT11 invoice"}, required=true)
    String invoice;

    public MeltQuoteCmd(BalanceService service) {
        super(service);
    }

    @Override
    public void run() {
        CashuWalletMintApi api = new CashuWalletMintApi(RestTemplateFactory.create());
        String mintUrl = this.mint != null ? this.mint : WalletConfig.load().defaultMintUrl();
        try {
            MintApi.MeltQuote q = api.quoteMelt(mintUrl, this.unit, this.amount, this.invoice);
            if (this.parent != null && this.parent.jsonOutput) {
                System.out.println("{\"quoteId\":\"" + q.quoteId() + "\",\"amount\":" + q.amount() + ",\"unit\":\"" + q.unit() + "\",\"feeReserve\":" + q.feeReserve() + "}");
            } else {
                System.out.println("Melt quote: " + q.quoteId() + " amount=" + q.amount() + " " + q.unit() + " feeReserve=" + q.feeReserve());
                System.out.println(q.rawJson());
            }
        }
        catch (MintApiException e) {
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to request melt quote. " + e.getMessage() + " Suggestion: Verify the mint URL, amount, and invoice, then retry.", e);
        }
    }
}

