/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.CliUtils;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.MintingService;
import xyz.tcheeric.wallet.core.StoragePaths;
import xyz.tcheeric.wallet.core.WalletConfig;

@CommandLine.Command(name="mint", description={"Mint tokens using binary denomination split. Requires H2 backend."})
public class MintCmd
extends WalletServiceCommand<MintingService> {
    @CommandLine.Option(names={"--mint"}, description={"Mint base URL"})
    String mint;
    @CommandLine.Option(names={"--unit"}, description={"Unit"}, required=true)
    String unit;
    @CommandLine.Option(names={"--amount"}, description={"Amount"}, required=true)
    long amount;
    @CommandLine.Option(names={"--quote-id"}, description={"Use an existing mint quote ID returned by mint-quote"})
    String quoteId;

    public MintCmd(MintingService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        String resolvedMintUrl = this.mint != null ? this.mint : config.defaultMintUrl();
        String normalizedQuoteId = this.normalizeQuoteId(this.quoteId);
        if (normalizedQuoteId == null) {
            normalizedQuoteId = this.loadPersistedQuoteId();
        }
        CliUtils.ensureH2Backend();
        ((MintingService)this.service).init(new WalletConfig(resolvedMintUrl, this.unit));
        if (normalizedQuoteId != null) {
            ((MintingService)this.service).mintWithQuote(normalizedQuoteId, this.amount, this.unit, resolvedMintUrl);
            this.clearPersistedQuoteId();
            System.out.println("Minted " + this.amount + " " + this.unit + " on " + resolvedMintUrl + " using quote " + normalizedQuoteId);
        } else {
            ((MintingService)this.service).mint(this.amount, this.unit, resolvedMintUrl);
            System.out.println("Minted " + this.amount + " " + this.unit + " on " + resolvedMintUrl);
        }
    }

    private String normalizeQuoteId(String value) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    private String loadPersistedQuoteId() {
        Path file = StoragePaths.walletHome().resolve("quotes/last-quote-id");
        if (!Files.exists(file, new LinkOption[0])) {
            return null;
        }
        try {
            String content = Files.readString(file, StandardCharsets.UTF_8).trim();
            return content.isEmpty() ? null : content;
        }
        catch (IOException e) {
            System.err.println("\u26a0\ufe0f  Failed to read cached quote id: " + e.getMessage());
            return null;
        }
    }

    private void clearPersistedQuoteId() {
        Path file = StoragePaths.walletHome().resolve("quotes/last-quote-id");
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

