/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.WalletMain;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.StoragePaths;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.api.MintApi;
import xyz.tcheeric.wallet.core.api.MintApiException;
import xyz.tcheeric.wallet.core.api.adapter.CashuWalletMintApi;
import xyz.tcheeric.wallet.core.api.adapter.RestTemplateFactory;

@CommandLine.Command(name="mint-quote", description={"Request a mint quote"})
public class MintQuoteCmd
extends WalletServiceCommand<BalanceService> {
    @CommandLine.ParentCommand
    WalletMain parent;
    @CommandLine.Option(names={"--mint"}, description={"Mint base URL"})
    String mint;
    @CommandLine.Option(names={"--unit"}, description={"Unit"}, required=true)
    String unit;
    @CommandLine.Option(names={"--amount"}, description={"Amount"}, required=true)
    long amount;

    public MintQuoteCmd(BalanceService service) {
        super(service);
    }

    @Override
    public void run() {
        CashuWalletMintApi api = new CashuWalletMintApi(RestTemplateFactory.create());
        String mintUrl = this.mint != null ? this.mint : WalletConfig.load().defaultMintUrl();
        try {
            MintApi.MintQuote q = api.quoteMint(mintUrl, this.unit, this.amount);
            if (this.parent != null && this.parent.jsonOutput) {
                System.out.println("{\"quoteId\":\"" + q.quoteId() + "\",\"amount\":" + q.amount() + ",\"unit\":\"" + q.unit() + "\"}");
            } else {
                System.out.println("Mint quote: " + q.quoteId() + " amount=" + q.amount() + " " + q.unit());
                System.out.println(q.rawJson());
            }
            this.persistQuoteId(q.quoteId());
        }
        catch (MintApiException e) {
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to request mint quote. " + e.getMessage() + " Suggestion: Verify the mint URL and amount, then retry.", e);
        }
    }

    private void persistQuoteId(String quoteId) {
        if (quoteId == null || quoteId.isBlank()) {
            return;
        }
        Path dir = StoragePaths.walletHome().resolve("quotes");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            Files.writeString(dir.resolve("last-quote-id"), (CharSequence)quoteId.trim(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("\u26a0\ufe0f  Failed to persist quote id for reuse: " + e.getMessage());
        }
    }
}

