/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import java.util.Map;
import java.util.UUID;
import picocli.CommandLine;
import xyz.tcheeric.wallet.core.MintRegistry;

@CommandLine.Command(name="mint-registry", description={"Manage local mint registry (url -> mintId)"})
public class MintRegistryCmd
implements Runnable {
    @CommandLine.Option(names={"--list"}, description={"List all registered mints"})
    boolean list;
    @CommandLine.Option(names={"--add"}, description={"Add a mapping: requires --url; --id is optional and defaults to a generated UUID"})
    boolean add;
    @CommandLine.Option(names={"--url"}, description={"Mint base URL (e.g., http://localhost:7777)"})
    String url;
    @CommandLine.Option(names={"--id"}, description={"Mint UUID"})
    String id;

    @Override
    public void run() {
        if (this.list) {
            Map<String, String> all = MintRegistry.all();
            if (all.isEmpty()) {
                System.out.println("No mints registered.");
            } else {
                all.forEach((k, v) -> System.out.println(k + " -> " + v));
            }
            return;
        }
        if (this.add) {
            if (this.url == null || this.url.isBlank()) {
                throw new CommandLine.ParameterException(new CommandLine(this), "--add requires --url. Suggestion: Provide --url=<mint_base_url> when using --add.");
            }
            String base = MintRegistryCmd.normalizeUrl(this.url);
            String mintId = this.id != null && !this.id.isBlank() ? this.id.trim() : UUID.randomUUID().toString();
            MintRegistry.putMint(base, mintId);
            System.out.println("Registered: " + base + " -> " + mintId);
            return;
        }
        System.out.println("Use --list to list mappings, or --add with --url [--id <uuid>] to add one.");
    }

    private static String normalizeUrl(String u) {
        Object url = u.trim();
        if (!((String)url).startsWith("http://") && !((String)url).startsWith("https://")) {
            url = "http://" + (String)url;
        }
        if (((String)url).endsWith("/")) {
            url = ((String)url).substring(0, ((String)url).length() - 1);
        }
        return url;
    }
}

