/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import nostr.base.Kind;
import nostr.base.PublicKey;
import picocli.CommandLine;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayService;
import xyz.tcheeric.wallet.core.nostr.NostrRelayOption;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletHistory;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletHistoryEntry;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletHistoryType;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletSnapshot;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletSnapshotEntry;
import xyz.tcheeric.wallet.core.nostr.cashu.service.CashuNipPublisher;
import xyz.tcheeric.wallet.core.nostr.cashu.service.CashuNipReader;
import xyz.tcheeric.wallet.core.nostr.filter.NostrFilterBuilder;
import xyz.tcheeric.wallet.core.nostr.filter.NostrServerSideFilter;

@CommandLine.Command(name="nostr", description={"Inspect and interact with configured Nostr relays."}, mixinStandardHelpOptions=true, subcommands={ListRelays.class, Publish.class, Subscribe.class, SubscribeAdv.class, CashuCmd.class})
public class NostrGatewayCmd
implements Runnable {
    @Override
    public void run() {
        CommandLine.usage(this, System.out);
    }

    private static String coerceHex(String s) {
        String filtered;
        if (s == null) {
            return null;
        }
        String t = s.trim();
        if (t.startsWith("0x") || t.startsWith("0X")) {
            t = t.substring(2);
        }
        return (filtered = t.replaceAll("[^0-9a-fA-F]", "")).isEmpty() ? null : filtered;
    }

    private static String normalizePubkey(String input) {
        String coerced;
        if (input == null) {
            return null;
        }
        String trimmed = input.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        if (trimmed.startsWith("npub") || trimmed.startsWith("NPUB")) {
            try {
                return new PublicKey(trimmed).toHexString().toLowerCase(Locale.ROOT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return (coerced = NostrGatewayCmd.coerceHex(trimmed)) != null ? coerced.toLowerCase(Locale.ROOT) : null;
    }

    @CommandLine.Command(name="cashu", description={"Publish and fetch Cashu NIP-60/61 data"}, subcommands={PublishSnapshot.class, PublishHistory.class, FetchSnapshot.class, FetchHistory.class})
    public static class CashuCmd
    implements Runnable {
        @Override
        public void run() {
            CommandLine.usage(this, System.out);
        }

        private static List<String> relayList(String value) {
            if (value == null || value.isBlank()) {
                return List.of();
            }
            return Arrays.stream(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        }

        private static List<WalletSnapshotEntry> parseBalances(String input) {
            ArrayList<WalletSnapshotEntry> out = new ArrayList<WalletSnapshotEntry>();
            for (String part : input.split(",")) {
                String p = part.trim();
                if (p.isEmpty()) continue;
                String[] kv = p.split(":");
                if (kv.length != 2) {
                    throw new CommandLine.ParameterException(new CommandLine(new CashuCmd()), "Invalid balance format: " + p);
                }
                long amt = Long.parseLong(kv[1]);
                out.add(new WalletSnapshotEntry(kv[0], amt));
            }
            return out;
        }

        @CommandLine.Command(name="fetch-history", description={"Subscribe to NIP-61 history and print matches"})
        public static class FetchHistory
        implements Runnable {
            @CommandLine.Option(names={"--author"}, required=true, description={"Author pubkey (x-only hex)"})
            String author;
            @CommandLine.Option(names={"--id"}, description={"History identifier (#d)"})
            String identifier;
            @CommandLine.Option(names={"--since"}, description={"Since (epoch seconds)"})
            Long since;
            @CommandLine.Option(names={"--until"}, description={"Until (epoch seconds)"})
            Long until;
            @CommandLine.Option(names={"--relays"}, description={"Comma separated relay URLs"})
            String relays;
            @CommandLine.Option(names={"--seconds"}, description={"How long to keep the subscription open"}, defaultValue="3")
            int seconds;
            private final NostrGatewayService gatewayService;

            public FetchHistory(NostrGatewayService gatewayService) {
                this.gatewayService = gatewayService;
            }

            @Override
            public void run() {
                CashuNipReader reader = new CashuNipReader(this.gatewayService);
                List<String> rs = CashuCmd.relayList(this.relays);
                Instant s = this.since != null ? Instant.ofEpochSecond(this.since) : null;
                Instant u = this.until != null ? Instant.ofEpochSecond(this.until) : null;
                try (AutoCloseable ignored = rs.isEmpty() ? reader.openHistorySubscription("hist-fetch", this.author, this.identifier, s, u, this::printHistory) : reader.openHistorySubscription(rs, "hist-fetch", this.author, this.identifier, s, u, this::printHistory);){
                    TimeUnit.SECONDS.sleep(Math.max(1, this.seconds));
                }
                catch (Exception e) {
                    throw new CommandLine.ExecutionException(new CommandLine(this), "History fetch failed", e);
                }
            }

            private void printHistory(WalletHistory h) {
                System.out.printf("history author=%s id=%s entries=%d%n", h.authorPubkeyHex(), h.identifier(), h.entries().size());
            }
        }

        @CommandLine.Command(name="fetch-snapshot", description={"Subscribe to NIP-60 snapshots and print matches"})
        public static class FetchSnapshot
        implements Runnable {
            @CommandLine.Option(names={"--author"}, required=true, description={"Author pubkey (x-only hex)"})
            String author;
            @CommandLine.Option(names={"--id"}, description={"Snapshot identifier (#d)"})
            String identifier;
            @CommandLine.Option(names={"--relays"}, description={"Comma separated relay URLs"})
            String relays;
            @CommandLine.Option(names={"--seconds"}, description={"How long to keep the subscription open"}, defaultValue="3")
            int seconds;
            private final NostrGatewayService gatewayService;

            public FetchSnapshot(NostrGatewayService gatewayService) {
                this.gatewayService = gatewayService;
            }

            @Override
            public void run() {
                CashuNipReader reader = new CashuNipReader(this.gatewayService);
                List<String> rs = CashuCmd.relayList(this.relays);
                try (AutoCloseable ignored = rs.isEmpty() ? reader.openSnapshotSubscription("snap-fetch", this.author, this.identifier, this::printSnapshot) : reader.openSnapshotSubscription(rs, "snap-fetch", this.author, this.identifier, this::printSnapshot);){
                    TimeUnit.SECONDS.sleep(Math.max(1, this.seconds));
                }
                catch (Exception e) {
                    throw new CommandLine.ExecutionException(new CommandLine(this), "Snapshot fetch failed", e);
                }
            }

            private void printSnapshot(WalletSnapshot s) {
                System.out.printf("snapshot author=%s id=%s version=%s balances=%d%n", s.authorPubkeyHex(), s.identifier(), s.version(), s.balances().size());
            }
        }

        @CommandLine.Command(name="publish-history", description={"Publish a NIP-61 wallet history (single entry)"})
        public static class PublishHistory
        implements Runnable {
            @CommandLine.Option(names={"--author"}, required=true, description={"Author pubkey (x-only hex)"})
            String author;
            @CommandLine.Option(names={"--id"}, description={"History identifier (#d)"})
            String identifier;
            @CommandLine.Option(names={"--version"}, defaultValue="1", description={"Schema version"})
            String version;
            @CommandLine.Option(names={"--type"}, required=true, description={"Entry type (MINT,MELT,SWAP_IN,SWAP_OUT,RECEIVE,SEND)"})
            String type;
            @CommandLine.Option(names={"--unit"}, required=true, description={"Cashu unit"})
            String unit;
            @CommandLine.Option(names={"--amount"}, required=true, description={"Amount (>0)"})
            long amount;
            @CommandLine.Option(names={"--memo"}, description={"Optional memo"})
            String memo;
            @CommandLine.Option(names={"--mint"}, description={"Optional mint URL"})
            String mintUrl;
            @CommandLine.Option(names={"--timestamp"}, description={"Epoch seconds (defaults now)"})
            Long ts;
            @CommandLine.Option(names={"--relays"}, description={"Comma separated relay URLs"})
            String relays;
            private final NostrGatewayService gatewayService;

            public PublishHistory(NostrGatewayService gatewayService) {
                this.gatewayService = gatewayService;
            }

            @Override
            public void run() {
                WalletHistoryEntry entry = new WalletHistoryEntry(Instant.ofEpochSecond(this.ts != null ? this.ts.longValue() : Instant.now().getEpochSecond()), WalletHistoryType.valueOf(this.type), this.unit, this.amount, this.memo, this.mintUrl);
                WalletHistory history = new WalletHistory(this.author, this.identifier, this.version, List.of(entry));
                CashuNipPublisher publisher = new CashuNipPublisher(this.gatewayService);
                List<String> rs = CashuCmd.relayList(this.relays);
                try {
                    if (rs.isEmpty()) {
                        publisher.publishHistory(history);
                    } else {
                        publisher.publishHistory(history, rs);
                    }
                }
                catch (IllegalStateException e) {
                    if (e.getMessage() != null && e.getMessage().toLowerCase().contains("no relays configured")) {
                        return;
                    }
                    throw e;
                }
                System.out.println("Published history entries=1");
            }
        }

        @CommandLine.Command(name="publish-snapshot", description={"Publish a NIP-60 wallet snapshot"})
        public static class PublishSnapshot
        implements Runnable {
            @CommandLine.Option(names={"--author"}, required=true, description={"Author pubkey (x-only hex)"})
            String author;
            @CommandLine.Option(names={"--id"}, description={"Snapshot identifier (#d)"})
            String identifier;
            @CommandLine.Option(names={"--version"}, defaultValue="1", description={"Schema version"})
            String version;
            @CommandLine.Option(names={"--balances"}, required=true, description={"Comma list unit:amount (e.g., sat:100,msat:0)"})
            String balances;
            @CommandLine.Option(names={"--relays"}, description={"Comma separated relay URLs"})
            String relays;
            private final NostrGatewayService gatewayService;

            public PublishSnapshot(NostrGatewayService gatewayService) {
                this.gatewayService = gatewayService;
            }

            @Override
            public void run() {
                List<WalletSnapshotEntry> entries = CashuCmd.parseBalances(this.balances);
                WalletSnapshot snap = new WalletSnapshot(this.author, this.identifier, this.version, Instant.now(), entries);
                CashuNipPublisher publisher = new CashuNipPublisher(this.gatewayService);
                List<String> rs = CashuCmd.relayList(this.relays);
                try {
                    if (rs.isEmpty()) {
                        publisher.publishSnapshot(snap);
                    } else {
                        publisher.publishSnapshot(snap, rs);
                    }
                }
                catch (IllegalStateException e) {
                    if (e.getMessage() != null && e.getMessage().toLowerCase().contains("no relays configured")) {
                        return;
                    }
                    throw e;
                }
                System.out.println("Published snapshot balances=" + entries.size());
            }
        }
    }

    @CommandLine.Command(name="subscribe-adv", description={"Subscribe using server-side filters (authors, kinds, tags, since/until)."})
    public static class SubscribeAdv
    implements Runnable {
        @CommandLine.Option(names={"--name"}, description={"Subscription name"}, defaultValue="cli-adv")
        String name;
        @CommandLine.Option(names={"--relays"}, description={"Comma separated relay URLs to target"})
        String relays;
        @CommandLine.Option(names={"--seconds"}, description={"How long to keep the subscription open"}, defaultValue="2")
        int seconds;
        @CommandLine.Option(names={"--authors"}, description={"Comma separated author pubkeys (x-only hex)"})
        String authors;
        @CommandLine.Option(names={"--kinds"}, description={"Comma separated kinds (ints)"})
        String kinds;
        @CommandLine.Option(names={"--since"}, description={"Since (epoch seconds)"})
        Long since;
        @CommandLine.Option(names={"--until"}, description={"Until (epoch seconds)"})
        Long until;
        @CommandLine.Option(names={"--ids"}, description={"Comma separated event ids"})
        String ids;
        @CommandLine.Option(names={"--e"}, description={"Comma separated referenced event ids (#e)"})
        String eRefs;
        @CommandLine.Option(names={"--p"}, description={"Comma separated referenced pubkeys (#p)"})
        String pRefs;
        @CommandLine.Option(names={"--d"}, description={"Comma separated identifiers (#d)"})
        String identifiers;
        @CommandLine.Option(names={"--a-kind"}, description={"Address kind for #a"})
        Integer aKind;
        @CommandLine.Option(names={"--a-author"}, description={"Address author pubkey hex for #a"})
        String aAuthor;
        @CommandLine.Option(names={"--a-id"}, description={"Address identifier for #a"})
        String aId;
        @CommandLine.Option(names={"--a-relay"}, description={"Address relay URL for #a (optional)"})
        String aRelay;
        @CommandLine.Option(names={"--tags"}, description={"Comma separated hashtags (#t) without the '#'"})
        String hashtags;
        @CommandLine.Option(names={"--limit"}, description={"Filters limit"}, defaultValue="100")
        int limit;
        private final NostrGatewayService gatewayService;
        private Predicate<NostrEvent> localFilter = event -> true;

        public SubscribeAdv(NostrGatewayService gatewayService) {
            this.gatewayService = gatewayService;
        }

        @Override
        public void run() {
            boolean anyConfigured;
            List<String> tags;
            String coercedAuthor;
            List<String> dList;
            List<String> pList;
            List<String> eList;
            List<String> idsList;
            int[] kindsList;
            NostrFilterBuilder b = NostrFilterBuilder.newBuilder();
            List<String> authorsList = this.csv(this.authors).stream().map(NostrGatewayCmd::normalizePubkey).filter(Objects::nonNull).toList();
            if (!authorsList.isEmpty()) {
                b.authors((String[])authorsList.toArray(String[]::new));
            }
            if ((kindsList = this.csv(this.kinds).stream().map(String::trim).filter(s -> !s.isEmpty()).map(Integer::parseInt).mapToInt(Integer::intValue).toArray()).length > 0) {
                b.kinds(kindsList);
            }
            if (this.since != null) {
                b.since(Instant.ofEpochSecond(this.since));
            }
            if (this.until != null) {
                b.until(Instant.ofEpochSecond(this.until));
            }
            if (!(idsList = this.csv(this.ids).stream().map(NostrGatewayCmd::coerceHex).filter(Objects::nonNull).toList()).isEmpty()) {
                b.ids((String[])idsList.toArray(String[]::new));
            }
            if (!(eList = this.csv(this.eRefs).stream().map(NostrGatewayCmd::coerceHex).filter(Objects::nonNull).toList()).isEmpty()) {
                b.referencedEvents((String[])eList.toArray(String[]::new));
            }
            if (!(pList = this.csv(this.pRefs).stream().map(NostrGatewayCmd::coerceHex).filter(Objects::nonNull).toList()).isEmpty()) {
                b.referencedPubKeys((String[])pList.toArray(String[]::new));
            }
            if (!(dList = this.csv(this.identifiers)).isEmpty()) {
                b.identifiers((String[])dList.toArray(String[]::new));
            }
            if (this.aKind != null && this.aAuthor != null && this.aId != null && (coercedAuthor = NostrGatewayCmd.coerceHex(this.aAuthor)) != null) {
                if (this.aRelay == null || this.aRelay.isBlank()) {
                    b.address(this.aKind, coercedAuthor, this.aId);
                } else {
                    b.address(this.aKind, coercedAuthor, this.aId, this.aRelay);
                }
            }
            if (!(tags = this.csv(this.hashtags)).isEmpty()) {
                b.hashtags((String[])tags.toArray(String[]::new));
            }
            b.limit(Math.max(1, this.limit));
            boolean bl = anyConfigured = !authorsList.isEmpty() || kindsList.length > 0 || this.since != null || this.until != null || !idsList.isEmpty() || !eList.isEmpty() || !pList.isEmpty() || this.aKind != null && this.aAuthor != null && this.aId != null && NostrGatewayCmd.coerceHex(this.aAuthor) != null || this.hashtags != null && !this.hashtags.isBlank();
            if (!anyConfigured) {
                b.kinds(Kind.TEXT_NOTE);
            }
            NostrServerSideFilter serverFilter = b.build();
            this.localFilter = this.buildPredicate(authorsList, kindsList, idsList);
            List<String> targets = this.relayList();
            try (AutoCloseable ignored = targets.isEmpty() ? this.gatewayService.subscribe(this.name, serverFilter, this::printEvent) : this.gatewayService.subscribe(targets, new NostrSubscription(this.name, serverFilter), this::printEvent);){
                TimeUnit.SECONDS.sleep(Math.max(1, this.seconds));
            }
            catch (Exception e) {
                throw new CommandLine.ExecutionException(new CommandLine(this), "Advanced subscription failed", e);
            }
        }

        private void printEvent(NostrEvent event) {
            if (!this.localFilter.test(event)) {
                System.out.printf("[%s] filtered event id=%s%n", event.createdAt(), event.id());
                return;
            }
            System.out.printf("[%s] kind=%d pubkey=%s content=%s%n", event.createdAt(), event.kind(), event.pubkey(), event.content());
        }

        private List<String> relayList() {
            if (this.relays == null || this.relays.isBlank()) {
                return List.of();
            }
            return Arrays.stream(this.relays.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        }

        private List<String> csv(String value) {
            if (value == null || value.isBlank()) {
                return List.of();
            }
            return Arrays.stream(value.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        }

        private Predicate<NostrEvent> buildPredicate(List<String> authors, int[] kinds, List<String> ids) {
            Predicate<NostrEvent> predicate = event -> true;
            if (!authors.isEmpty()) {
                Set authorSet = authors.stream().collect(Collectors.toSet());
                predicate = predicate.and(event -> {
                    String normalized = NostrGatewayCmd.normalizePubkey(event.pubkey());
                    return normalized != null && authorSet.contains(normalized);
                });
            }
            if (kinds.length > 0) {
                Set kindSet = Arrays.stream(kinds).boxed().collect(Collectors.toSet());
                predicate = predicate.and(event -> kindSet.contains(event.kind()));
            }
            if (!ids.isEmpty()) {
                Set idSet = ids.stream().map(String::toLowerCase).collect(Collectors.toSet());
                predicate = predicate.and(event -> {
                    String id = event.id();
                    return id != null && idSet.contains(id.toLowerCase());
                });
            }
            return predicate;
        }
    }

    @CommandLine.Command(name="subscribe", description={"Subscribe for events for a limited duration and print matches."})
    public static class Subscribe
    implements Runnable {
        @CommandLine.Option(names={"--relays"}, description={"Comma separated relay URLs to target"})
        String relays;
        @CommandLine.Option(names={"--seconds"}, description={"How long to keep the subscription open"}, defaultValue="2")
        int seconds;
        private final NostrGatewayService gatewayService;

        public Subscribe(NostrGatewayService gatewayService) {
            this.gatewayService = gatewayService;
        }

        @Override
        public void run() {
            Predicate<NostrEvent> filter2 = event -> true;
            NostrSubscription subscription = new NostrSubscription("cli-subscription", filter2);
            List<String> targets = this.relayList();
            try (AutoCloseable ignored = targets.isEmpty() ? this.gatewayService.subscribe(subscription, this::printEvent) : this.gatewayService.subscribe(targets, subscription, this::printEvent);){
                TimeUnit.SECONDS.sleep(Math.max(1, this.seconds));
            }
            catch (Exception e) {
                throw new CommandLine.ExecutionException(new CommandLine(this), "Subscription failed", e);
            }
        }

        private void printEvent(NostrEvent event) {
            System.out.printf("[%s] kind=%d content=%s%n", event.createdAt(), event.kind(), event.content());
        }

        private List<String> relayList() {
            if (this.relays == null || this.relays.isBlank()) {
                return List.of();
            }
            return Arrays.stream(this.relays.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        }
    }

    @CommandLine.Command(name="publish", description={"Publish a test event to configured relays."})
    public static class Publish
    implements Runnable {
        @CommandLine.Option(names={"--kind"}, description={"Nostr event kind"}, defaultValue="27235")
        int kind;
        @CommandLine.Option(names={"--content"}, required=true, description={"Event content"})
        String content;
        @CommandLine.Option(names={"--relays"}, description={"Comma separated relay URLs to target"})
        String relays;
        private final NostrGatewayService gatewayService;

        public Publish(NostrGatewayService gatewayService) {
            this.gatewayService = gatewayService;
        }

        @Override
        public void run() {
            NostrEvent event = new NostrEvent(UUID.randomUUID().toString(), this.gatewayService.walletSigningKey().publicKeyHex(), this.kind, this.content, Instant.now(), List.of(), null);
            List<String> targets = this.relayList();
            if (targets.isEmpty()) {
                this.gatewayService.publish(event);
            } else {
                this.gatewayService.publish(event, targets);
            }
            System.out.printf("Published event %s to %s relays.%n", event.id(), targets.isEmpty() ? "all configured" : Integer.valueOf(targets.size()));
        }

        private List<String> relayList() {
            if (this.relays == null || this.relays.isBlank()) {
                return List.of();
            }
            return Arrays.stream(this.relays.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toList();
        }
    }

    @CommandLine.Command(name="list", description={"List configured relay endpoints and authentication state."})
    public static class ListRelays
    implements Runnable {
        private final NostrGatewayService gatewayService;

        public ListRelays(NostrGatewayService gatewayService) {
            this.gatewayService = gatewayService;
        }

        @Override
        public void run() {
            List<NostrRelayOption> options = this.gatewayService.activeRelayOptions();
            if (options.isEmpty()) {
                System.out.println("No relays configured. Set NOSTR_RELAYS or nostr.relays in config.properties.");
                return;
            }
            System.out.println("Configured Nostr relays:");
            this.gatewayService.relayAuthStates().forEach((url, auth) -> System.out.printf(" - %s (auth=%s)%n", url, auth));
        }
    }
}

