/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.WalletMain;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.api.MintApiException;
import xyz.tcheeric.wallet.core.api.adapter.CashuWalletMintApi;
import xyz.tcheeric.wallet.core.api.adapter.RestTemplateFactory;

@CommandLine.Command(name="quote-status", description={"Check the payment status of a melt quote (NUT-05)"})
public class QuoteStatusCmd
extends WalletServiceCommand<BalanceService> {
    @CommandLine.ParentCommand
    WalletMain parent;
    @CommandLine.Parameters(index="0", description={"Quote ID to check"}, arity="0..1")
    String quoteIdParam;
    @CommandLine.Option(names={"--quote", "-q"}, description={"Quote ID to check (alternative to positional argument)"})
    String quoteIdOption;
    @CommandLine.Option(names={"--mint"}, description={"Mint base URL"})
    String mint;
    @CommandLine.Option(names={"--unit"}, description={"Unit (default: sat)"})
    String unit = "sat";

    public QuoteStatusCmd(BalanceService service) {
        super(service);
    }

    @Override
    public void run() {
        String quoteId;
        String string = quoteId = this.quoteIdParam != null && !this.quoteIdParam.isBlank() ? this.quoteIdParam : this.quoteIdOption;
        if (quoteId == null || quoteId.isBlank()) {
            throw new CommandLine.ParameterException(new CommandLine(this), "Quote ID is required. Provide either: 'quote-status <quote-id>' or 'quote-status --quote <quote-id>'");
        }
        String mintUrl = this.mint != null ? this.mint : WalletConfig.load().defaultMintUrl();
        CashuWalletMintApi api = new CashuWalletMintApi(RestTemplateFactory.create());
        try {
            boolean paid = api.meltQuotePaid(mintUrl, this.unit, quoteId);
            if (this.parent != null && this.parent.jsonOutput) {
                System.out.println("{\"quoteId\":\"" + quoteId + "\",\"paid\":" + paid + ",\"status\":\"" + (paid ? "PAID" : "UNPAID") + "\"}");
            } else {
                System.out.println("Quote " + quoteId + " status: " + (paid ? "PAID \u2705" : "UNPAID \u23f3"));
            }
        }
        catch (MintApiException e) {
            System.err.println("\u274c Failed to check quote status: " + e.getMessage());
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to check quote status for quote " + quoteId + ". Suggestion: Verify the quote ID is correct and the mint is accessible.", e);
        }
    }
}

