/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.CliUtils;
import xyz.tcheeric.wallet.cli.NostrRelayUtils;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.application.ReceiveUseCase;
import xyz.tcheeric.wallet.core.exception.WalletOperationException;
import xyz.tcheeric.wallet.core.util.MessageUtils;

@CommandLine.Command(name="receive", description={"Import token proofs or listen for Nostr transfers and acknowledge after commit."})
public class ReceiveCmd
implements Runnable {
    private final ReceiveUseCase receiveUseCase;
    private final boolean requireH2Backend;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--token"}, description={"Token string to import directly"})
    String token;
    @CommandLine.Option(names={"--listen"}, description={"Listen for incoming Nostr events targeting this wallet"})
    boolean listen;
    @CommandLine.Option(names={"--seconds"}, description={"Duration to keep listen mode open"}, defaultValue="30")
    int seconds = 30;
    @CommandLine.Option(names={"--relays"}, split=",", description={"Comma separated relay list to use in listen mode"})
    List<String> relays;

    public ReceiveCmd(ReceiveUseCase receiveUseCase, boolean requireH2Backend) {
        this.receiveUseCase = Objects.requireNonNull(receiveUseCase, "receiveUseCase");
        this.requireH2Backend = requireH2Backend;
    }

    @Override
    public void run() {
        if ((this.token == null || this.token.isBlank()) && !this.listen) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Specify --token or --listen");
        }
        if (this.seconds <= 0 && this.listen) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "--seconds must be positive");
        }
        if (this.requireH2Backend) {
            CliUtils.ensureH2Backend();
        }
        WalletConfig config = WalletConfig.load();
        if (this.token != null && !this.token.isBlank()) {
            this.handleTokenImport(config, this.token.trim());
        }
        if (this.listen) {
            this.handleListen(config, Math.max(1, this.seconds));
        }
    }

    private void handleTokenImport(WalletConfig config, String tokenValue) {
        try {
            ReceiveUseCase.ImportTokenResult result = this.receiveUseCase.importToken(new ReceiveUseCase.ImportTokenCommand(config, tokenValue));
            PrintWriter out = this.output();
            if (result.hasNewProofs()) {
                out.printf("Imported %d proofs totaling %d %s from %s (duplicates: %d)%n", result.importResult().importedCount(), result.importResult().importedAmount(), result.unit(), result.mintUrl(), result.importResult().duplicateCount());
            } else {
                out.printf("No new proofs imported from %s; duplicates totaled %d %s%n", result.mintUrl(), result.importResult().duplicateAmount(), result.unit());
            }
            out.flush();
        }
        catch (WalletOperationException e) {
            PrintWriter err = this.error();
            err.printf("Failed to import proofs: %s (code=%s)%n", e.getUserMessage(), e.getErrorCode());
            err.flush();
            throw new CommandLine.ExecutionException(this.commandLine(), e.getUserMessage(), e);
        }
    }

    private void handleListen(WalletConfig config, int durationSeconds) {
        ReceiveUseCase.ListenForTransfersResult result;
        List<String> normalized = NostrRelayUtils.normalize(this.relays);
        PrintWriter out = this.output();
        out.printf("Listening for transfers on %s for %d seconds\u2026%n", normalized.isEmpty() ? "configured relays" : String.join((CharSequence)", ", normalized), durationSeconds);
        out.flush();
        try {
            result = this.receiveUseCase.listenForTransfers(new ReceiveUseCase.ListenForTransfersCommand(config, durationSeconds, normalized));
        }
        catch (RuntimeException e) {
            PrintWriter err = this.error();
            err.printf("Failed to subscribe to relays: %s%n", MessageUtils.safeMessage(e));
            err.flush();
            throw e;
        }
        for (ReceiveUseCase.TransferProcessingResult event : result.events()) {
            this.renderEventResult(event);
        }
    }

    private void renderEventResult(ReceiveUseCase.TransferProcessingResult event) {
        PrintWriter out = this.output();
        if (event.status() == ReceiveUseCase.ProcessingStatus.IMPORTED && event.importResult() != null) {
            out.printf("Imported %d proofs totaling %d %s from %s (duplicates: %d) [event %s]%n", event.importResult().importedCount(), event.importResult().importedAmount(), event.unit(), event.mintUrl(), event.importResult().duplicateCount(), event.eventId());
        } else if (event.status() == ReceiveUseCase.ProcessingStatus.DUPLICATE_ONLY && event.importResult() != null) {
            out.printf("No new proofs imported from %s; duplicates totaled %d %s [event %s]%n", event.mintUrl(), event.importResult().duplicateAmount(), event.unit(), event.eventId());
        } else if (event.status() == ReceiveUseCase.ProcessingStatus.IGNORED) {
            out.printf("Ignored event %s: %s%n", event.eventId(), this.safeText(event.errorMessage()));
        } else {
            this.error().printf("Failed to process event %s: %s%n", event.eventId(), this.safeText(event.errorMessage()));
        }
        if (!event.ackPublished() && event.status() != ReceiveUseCase.ProcessingStatus.IGNORED && event.ackErrorMessage() != null) {
            this.error().printf("Imported proofs but failed to acknowledge event %s: %s%n", event.eventId(), event.ackErrorMessage());
        }
        out.flush();
    }

    private PrintWriter output() {
        if (this.spec != null && this.spec.commandLine() != null) {
            return this.spec.commandLine().getOut();
        }
        return new PrintWriter(System.out, true);
    }

    private PrintWriter error() {
        if (this.spec != null && this.spec.commandLine() != null) {
            return this.spec.commandLine().getErr();
        }
        return new PrintWriter(System.err, true);
    }

    private CommandLine commandLine() {
        if (this.spec != null && this.spec.commandLine() != null) {
            return this.spec.commandLine();
        }
        return new CommandLine(this);
    }

    private String safeText(String message) {
        return message == null || message.isBlank() ? "unknown error" : message;
    }
}

