/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import java.util.UUID;
import picocli.CommandLine;
import xyz.tcheeric.wallet.core.MintRegistry;
import xyz.tcheeric.wallet.core.StoragePaths;
import xyz.tcheeric.wallet.core.WalletConfig;

@CommandLine.Command(name="set-active-mint", description={"Set the default mint URL for subsequent commands."})
public class SetActiveMintCmd
implements Runnable {
    @CommandLine.Option(names={"--url"}, required=true, description={"Mint base URL (e.g., http://localhost:7777)"})
    String url;

    @Override
    public void run() {
        String normalized = SetActiveMintCmd.normalizeUrl(this.url);
        this.persistMintConfig(normalized);
        this.ensureRegistryEntry(normalized);
        System.out.println("Active mint set to " + normalized);
    }

    private void persistMintConfig(String mintUrl) {
        StoragePaths.ensureDirs();
        Path configPath = StoragePaths.configFile();
        Properties props = new Properties();
        if (Files.exists(configPath, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(configPath, new OpenOption[0]);){
                props.load(in);
            }
            catch (IOException e) {
                throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to load wallet config at " + String.valueOf(configPath) + ": " + e.getMessage(), e);
            }
        }
        props.setProperty("defaultMintUrl", mintUrl);
        props.putIfAbsent("defaultUnit", WalletConfig.load().defaultUnit());
        try (OutputStream out = Files.newOutputStream(configPath, new OpenOption[0]);){
            props.store(out, "cashu wallet config");
        }
        catch (IOException e) {
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to persist wallet config at " + String.valueOf(configPath) + ": " + e.getMessage(), e);
        }
    }

    private void ensureRegistryEntry(String mintUrl) {
        if (MintRegistry.getMintId(mintUrl) == null) {
            MintRegistry.putMint(mintUrl, UUID.randomUUID().toString());
        }
    }

    private static String normalizeUrl(String value) {
        Object trimmed = value.trim();
        if (!((String)trimmed).startsWith("http://") && !((String)trimmed).startsWith("https://")) {
            trimmed = "http://" + (String)trimmed;
        }
        if (((String)trimmed).endsWith("/")) {
            trimmed = ((String)trimmed).substring(0, ((String)trimmed).length() - 1);
        }
        return trimmed;
    }
}

