/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import xyz.tcheeric.bips.bip39.Bip39;
import xyz.tcheeric.wallet.cli.WalletMain;
import xyz.tcheeric.wallet.cli.mnemonic.MnemonicStorageService;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.H2WalletService;
import xyz.tcheeric.wallet.core.H2WalletStorageAdapter;
import xyz.tcheeric.wallet.core.ports.WalletStorage;
import xyz.tcheeric.wallet.core.state.WalletState;
import xyz.tcheeric.wallet.storage.file.FileWalletStorage;

@CommandLine.Command(name="show-mnemonic", description={"Display stored mnemonic phrase (requires passphrase)"}, mixinStandardHelpOptions=true)
public class ShowMnemonicCmd
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShowMnemonicCmd.class);
    private static final String DEFAULT_WALLET_ID = "default";
    @CommandLine.ParentCommand
    WalletMain parent;
    private final BalanceService balanceService;
    private final MnemonicStorageService mnemonicStorageService;
    private final WalletStorage overrideWalletStorage;
    @CommandLine.Option(names={"-p", "--passphrase"}, description={"Passphrase to decrypt mnemonic"}, required=true, interactive=true)
    String passphrase;
    @CommandLine.Option(names={"--verify"}, description={"Verify mnemonic checksum after retrieval"})
    boolean verify;

    public ShowMnemonicCmd(BalanceService balanceService) {
        this(balanceService, new MnemonicStorageService(), null);
    }

    public ShowMnemonicCmd() {
        this(null, new MnemonicStorageService(), null);
    }

    ShowMnemonicCmd(BalanceService balanceService, MnemonicStorageService mnemonicStorageService, WalletStorage overrideWalletStorage) {
        this.balanceService = balanceService;
        this.mnemonicStorageService = mnemonicStorageService;
        this.overrideWalletStorage = overrideWalletStorage;
    }

    @Override
    public void run() {
        try {
            log.info("show_mnemonic_started verify={}", (Object)this.verify);
            WalletState state = this.loadWalletState();
            if (!state.hasMnemonic()) {
                this.reportNoMnemonicStored();
                return;
            }
            String mnemonic = this.mnemonicStorageService.retrieveMnemonic(state, this.passphrase);
            if (this.verify && !Bip39.validateMnemonic(mnemonic).isValid()) {
                this.reportInvalidChecksum();
                return;
            }
            this.displayMnemonic(mnemonic, this.verify);
            log.info("show_mnemonic_completed verified={}", (Object)this.verify);
        }
        catch (MnemonicStorageService.MnemonicRetrievalException e) {
            this.reportError("Failed to decrypt mnemonic. Incorrect passphrase or data corruption.", "Enter the same passphrase that was provided during `generate-mnemonic --store-mnemonic`.");
            log.warn("show_mnemonic_failed reason=decrypt error={}", (Object)e.getMessage());
        }
        catch (IllegalStateException e) {
            this.reportError(e.getMessage(), "Initialize the wallet with `wallet init` or restore a backup before showing the mnemonic.");
            log.warn("show_mnemonic_failed reason=state_missing");
        }
        catch (Exception e) {
            this.reportError("Failed to display mnemonic.", "Retry the command with the correct parameters and ensure wallet state is accessible.");
            log.error("show_mnemonic_failed error={}", (Object)e.getMessage(), (Object)e);
        }
    }

    private WalletState loadWalletState() {
        WalletStorage storage = this.resolveWalletStorage();
        return storage.load(DEFAULT_WALLET_ID).orElseThrow(() -> new IllegalStateException("Failed to load wallet state. Wallet not initialized. Suggestion: Run `wallet init` first."));
    }

    private WalletStorage resolveWalletStorage() {
        if (this.overrideWalletStorage != null) {
            return this.overrideWalletStorage;
        }
        BalanceService balanceService = this.balanceService;
        if (balanceService instanceof H2WalletService) {
            H2WalletService h2 = (H2WalletService)balanceService;
            return new H2WalletStorageAdapter(h2.getDataSource());
        }
        return new FileWalletStorage();
    }

    private void displayMnemonic(String mnemonic, boolean verified) {
        if (this.parent != null && this.parent.jsonOutput) {
            System.out.println("{\"status\":\"ok\",\"mnemonic\":\"" + mnemonic + "\",\"verified\":" + verified + "}");
            return;
        }
        System.out.println();
        System.out.println("\u26a0\ufe0f  SECURITY WARNING");
        System.out.println("   \u2022 Anyone with this phrase can control your funds");
        System.out.println("   \u2022 Write it on paper and store it securely offline");
        System.out.println("   \u2022 Never share screenshots, emails, or chat messages");
        System.out.println();
        System.out.println("Stored mnemonic:");
        System.out.println("\u2501".repeat(60));
        System.out.println(mnemonic);
        System.out.println("\u2501".repeat(60));
        System.out.println();
        if (verified) {
            System.out.println("Checksum verification: \u2705 PASSED");
        } else {
            System.out.println("Checksum verification: skipped (use --verify to enable).");
        }
    }

    private void reportNoMnemonicStored() {
        this.reportError("No mnemonic stored in wallet state.", "Run `wallet generate-mnemonic --store-mnemonic` before trying to display it.");
        log.warn("show_mnemonic_failed reason=no_mnemonic");
    }

    private void reportInvalidChecksum() {
        this.reportError("Mnemonic checksum verification failed.", "Re-store the mnemonic using `wallet generate-mnemonic --store-mnemonic`.");
        log.error("show_mnemonic_failed reason=invalid_checksum");
    }

    private void reportError(String whatHappened, String suggestion) {
        String message = whatHappened + " Suggestion: " + suggestion;
        if (this.parent != null && this.parent.jsonOutput) {
            System.out.println("{\"status\":\"error\",\"message\":\"" + message + "\"}");
        } else {
            System.err.println("\u274c " + message);
        }
    }
}

