/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import java.util.Map;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.WalletMain;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.MintingService;
import xyz.tcheeric.wallet.core.UnspentSummary;
import xyz.tcheeric.wallet.core.WalletConfig;

@CommandLine.Command(name="status", description={"Show unspent proofs breakdown (H2 backend)"})
public class StatusCmd
extends WalletServiceCommand<MintingService> {
    @CommandLine.ParentCommand
    WalletMain parent;
    @CommandLine.Option(names={"--mint"}, description={"Mint base URL"})
    String mint;
    @CommandLine.Option(names={"--unit"}, description={"Unit"}, required=true)
    String unit;

    public StatusCmd(MintingService service) {
        super(service);
    }

    @Override
    public void run() {
        String mintUrl;
        WalletConfig config = WalletConfig.load();
        String string = mintUrl = this.mint != null ? this.mint : config.defaultMintUrl();
        if (!"h2".equalsIgnoreCase(System.getenv().getOrDefault("WALLET_STORAGE", "file"))) {
            throw new CommandLine.ExecutionException(new CommandLine(this), "status requires WALLET_STORAGE=h2");
        }
        ((MintingService)this.service).init(new WalletConfig(mintUrl, this.unit));
        UnspentSummary s = ((MintingService)this.service).status(this.unit, mintUrl);
        if (this.parent != null && this.parent.jsonOutput) {
            StringBuilder jsonBuilder = new StringBuilder();
            jsonBuilder.append('{').append("\"total\":").append(s.getTotal()).append(',').append("\"unit\":\"").append(this.unit).append("\",").append("\"breakdown\":{");
            boolean first = true;
            for (Map.Entry e : s.getByAmount().entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
                if (!first) {
                    jsonBuilder.append(',');
                }
                jsonBuilder.append('\"').append(e.getKey()).append("\":").append(e.getValue());
                first = false;
            }
            jsonBuilder.append("}}\n");
            System.out.print(jsonBuilder.toString());
        } else {
            System.out.println("Total: " + s.getTotal() + " " + this.unit);
            System.out.println("Breakdown:");
            for (Map.Entry e : s.getByAmount().entrySet().stream().sorted(Map.Entry.comparingByKey()).toList()) {
                System.out.println("  " + String.valueOf(e.getKey()) + " x " + String.valueOf(e.getValue()));
            }
        }
    }
}

