/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import java.util.List;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.WalletMain;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.H2WalletService;
import xyz.tcheeric.wallet.core.MintingService;
import xyz.tcheeric.wallet.core.VerifySummary;
import xyz.tcheeric.wallet.core.WalletConfig;

@CommandLine.Command(name="verify", description={"Verify unspent proofs with mint /check and reconcile spent state. Requires H2 backend."})
public class VerifyCmd
extends WalletServiceCommand<MintingService> {
    @CommandLine.ParentCommand
    WalletMain parent;
    @CommandLine.Option(names={"--mint"}, description={"Mint base URL"})
    String mint;
    @CommandLine.Option(names={"--unit"}, description={"Unit"})
    String unit;
    @CommandLine.Option(names={"--all"}, description={"Verify across all units present in DB"})
    boolean all;

    public VerifyCmd(MintingService service) {
        super(service);
    }

    @Override
    public void run() {
        String mintUrl;
        WalletConfig config = WalletConfig.load();
        String string = mintUrl = this.mint != null ? this.mint : config.defaultMintUrl();
        if (!"h2".equalsIgnoreCase(System.getenv().getOrDefault("WALLET_STORAGE", "file"))) {
            throw new CommandLine.ExecutionException(new CommandLine(this), "verify requires WALLET_STORAGE=h2");
        }
        if (this.all) {
            if (!(this.service instanceof H2WalletService)) {
                throw new CommandLine.ExecutionException(new CommandLine(this), "--all requires WALLET_STORAGE=h2");
            }
            H2WalletService h2Service = (H2WalletService)this.service;
            List<String> units = h2Service.listUnits(mintUrl);
            int total = 0;
            int encrypted = 0;
            int plaintext = 0;
            for (String u : units) {
                h2Service.init(new WalletConfig(mintUrl, u));
                VerifySummary r = h2Service.verify(u, mintUrl);
                total += r.total();
                encrypted += r.encrypted();
                plaintext += r.plaintext();
            }
            if (this.parent != null && this.parent.jsonOutput) {
                System.out.println("{\"total\":" + total + ",\"encrypted\":" + encrypted + ",\"plaintext\":" + plaintext + "}");
            } else {
                System.out.println("Checked: " + total + ", Encrypted: " + encrypted + ", Plaintext: " + plaintext);
            }
        } else {
            if (this.unit == null || this.unit.isBlank()) {
                throw new CommandLine.ParameterException(new CommandLine(this), "Missing unit. --unit is required unless --all is provided. Suggestion: Specify --unit=<unit> or pass --all to check all units.");
            }
            ((MintingService)this.service).init(new WalletConfig(mintUrl, this.unit));
            VerifySummary r = ((MintingService)this.service).verify(this.unit, mintUrl);
            if (this.parent != null && this.parent.jsonOutput) {
                System.out.println("{\"total\":" + r.total() + ",\"encrypted\":" + r.encrypted() + ",\"plaintext\":" + r.plaintext() + "}");
            } else {
                System.out.println("Checked: " + r.total() + ", Encrypted: " + r.encrypted() + ", Plaintext: " + r.plaintext() + "\n");
            }
        }
    }
}

