/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands;

import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.WalletMain;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.H2WalletService;
import xyz.tcheeric.wallet.core.VerifySummary;
import xyz.tcheeric.wallet.core.WalletConfig;

@CommandLine.Command(name="verify-encryption", description={"Report encrypted vs plaintext rows. With --fix, encrypt remaining plaintext rows (if encryption enabled). Requires H2 backend."})
public class VerifyEncryptionCmd
extends WalletServiceCommand<BalanceService> {
    @CommandLine.ParentCommand
    WalletMain parent;
    @CommandLine.Option(names={"--mint"}, description={"Mint base URL"})
    String mint;
    @CommandLine.Option(names={"--unit"}, description={"Unit"}, required=true)
    String unit;
    @CommandLine.Option(names={"--fix"}, description={"Encrypt any remaining plaintext rows"})
    boolean fix;

    public VerifyEncryptionCmd(BalanceService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        String mintUrl = this.mint != null ? this.mint : config.defaultMintUrl();
        this.service.init(new WalletConfig(mintUrl, this.unit));
        BalanceService balanceService = this.service;
        if (balanceService instanceof H2WalletService) {
            H2WalletService h2Service = (H2WalletService)balanceService;
            VerifySummary report = h2Service.verifyEncryption(this.unit, mintUrl, this.fix);
            if (this.parent != null && this.parent.jsonOutput) {
                System.out.println("{\"total\":" + report.total() + ",\"encrypted\":" + report.encrypted() + ",\"plaintext\":" + report.plaintext() + "}");
            } else {
                System.out.println("Total: " + report.total() + ", Encrypted: " + report.encrypted() + ", Plaintext: " + report.plaintext());
            }
        } else {
            throw new CommandLine.ExecutionException(new CommandLine(this), "H2 backend required. WALLET_STORAGE must be set to 'h2'. Suggestion: Export WALLET_STORAGE=h2 and retry.");
        }
    }
}

