/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands.voucher;

import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.VoucherService;
import xyz.tcheeric.wallet.core.WalletConfig;

@CommandLine.Command(name="backup", description={"Backup all vouchers to Nostr (NIP-17 encrypted)"})
public class BackupVouchersCmd
extends WalletServiceCommand<VoucherService> {
    @CommandLine.Option(names={"--nostr"}, defaultValue="true", description={"Backup vouchers to Nostr relays using NIP-17 encrypted DMs"})
    private boolean nostr;

    public BackupVouchersCmd(VoucherService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        ((VoucherService)this.service).init(config);
        if (!this.nostr) {
            System.out.println("\u2139 Nostr backup disabled. Use --nostr to enable.");
            return;
        }
        try {
            System.out.println("Backing up vouchers to Nostr...");
            ((VoucherService)this.service).backupToNostr();
            System.out.println("\u2705 Vouchers backed up successfully");
        }
        catch (UnsupportedOperationException e) {
            System.err.println("\u26a0 Voucher backup not yet fully implemented");
            System.err.println(e.getMessage());
            System.err.println();
            System.err.println("This feature requires Nostr backup service integration.");
            System.err.println("Please check back in a future release.");
            throw new CommandLine.ExecutionException(new CommandLine(this), e.getMessage());
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to backup vouchers: " + e.getMessage());
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to backup vouchers", e);
        }
    }
}

