/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands.voucher;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.Instant;
import java.util.Optional;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.VoucherService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.state.StoredVoucher;

@CommandLine.Command(name="check-status", description={"Check voucher status (optionally refresh from ledger)"})
public class CheckVoucherStatusCmd
extends WalletServiceCommand<VoucherService> {
    @CommandLine.Parameters(index="0", description={"Voucher ID"})
    String voucherId;
    @CommandLine.Option(names={"--refresh"}, description={"Refresh status from Nostr ledger"})
    boolean refreshFromLedger;
    @CommandLine.Option(names={"--json"}, description={"Output JSON"})
    boolean jsonOutput;

    public CheckVoucherStatusCmd(VoucherService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        ((VoucherService)this.service).init(config);
        try {
            StoredVoucher voucher;
            if (this.refreshFromLedger) {
                try {
                    Optional<StoredVoucher> refreshed = ((VoucherService)this.service).refreshStatus(this.voucherId);
                    if (refreshed.isEmpty()) {
                        System.err.println("\u274c Voucher not found: " + this.voucherId);
                        throw new CommandLine.ExecutionException(new CommandLine(this), "Voucher not found");
                    }
                    voucher = refreshed.get();
                    System.out.println("\u2705 Status refreshed from ledger");
                    System.out.println();
                }
                catch (Exception e) {
                    System.err.println("\u26a0\ufe0f  Failed to refresh from ledger: " + e.getMessage());
                    System.err.println("\ud83d\udcc1 Falling back to local status");
                    System.out.println();
                    Optional<StoredVoucher> voucherOpt = ((VoucherService)this.service).getVoucher(this.voucherId);
                    if (voucherOpt.isEmpty()) {
                        System.err.println("\u274c Voucher not found: " + this.voucherId);
                        throw new CommandLine.ExecutionException(new CommandLine(this), "Voucher not found");
                    }
                    voucher = voucherOpt.get();
                }
            } else {
                Optional<StoredVoucher> voucherOpt = ((VoucherService)this.service).getVoucher(this.voucherId);
                if (voucherOpt.isEmpty()) {
                    System.err.println("\u274c Voucher not found: " + this.voucherId);
                    throw new CommandLine.ExecutionException(new CommandLine(this), "Voucher not found");
                }
                voucher = voucherOpt.get();
            }
            if (this.jsonOutput) {
                this.printJsonOutput(voucher);
            } else {
                this.printPlainOutput(voucher, this.refreshFromLedger);
            }
        }
        catch (CommandLine.ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to check voucher status: " + e.getMessage());
            e.printStackTrace(System.err);
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to check voucher status", e);
        }
    }

    private void printPlainOutput(StoredVoucher voucher, boolean wasRefreshed) {
        System.out.println("Voucher Status");
        System.out.println("==============");
        System.out.println();
        System.out.println("ID:              " + voucher.voucherId());
        System.out.println("Amount:          " + voucher.faceValue() + " " + voucher.unit());
        System.out.println("Status:          " + this.formatStatus(voucher));
        System.out.println("Issued:          " + String.valueOf(voucher.issuedAt()));
        if (voucher.expiresAt() != null) {
            Instant expiry = Instant.ofEpochSecond(voucher.expiresAt());
            boolean expired = voucher.isExpired();
            System.out.println("Expires:         " + String.valueOf(expiry) + (expired ? " (EXPIRED)" : ""));
        } else {
            System.out.println("Expires:         Never");
        }
        if (voucher.memo() != null) {
            System.out.println("Memo:            " + voucher.memo());
        }
        System.out.println();
        System.out.println("Source:          " + (wasRefreshed ? "Ledger (refreshed)" : "Local storage"));
        boolean isActive = voucher.isActive();
        System.out.println("Active:          " + (isActive ? "Yes" : "No"));
        if (!wasRefreshed && !voucher.status().equals("redeemed")) {
            System.out.println();
            System.out.println("\ud83d\udca1 Use --refresh to check latest status from Nostr ledger");
        }
    }

    private void printJsonOutput(StoredVoucher voucher) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule(new JavaTimeModule());
            System.out.println(mapper.writerWithDefaultPrettyPrinter().writeValueAsString(voucher));
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to serialize voucher to JSON", e);
        }
    }

    private String formatStatus(StoredVoucher voucher) {
        String status = voucher.status().toUpperCase();
        if (voucher.isExpired()) {
            return status + " (EXPIRED)";
        }
        return status;
    }
}

