/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands.voucher;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.VoucherService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.state.StoredVoucher;

@CommandLine.Command(name="export", description={"Export vouchers to JSON file"})
public class ExportVouchersCmd
extends WalletServiceCommand<VoucherService> {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--format"}, description={"Export format (only 'json' supported)"}, required=true)
    String format;
    @CommandLine.Option(names={"--output"}, description={"Output file path"}, required=true)
    String outputPath;
    @CommandLine.Option(names={"--unit"}, description={"Filter by currency unit"})
    String unit;
    @CommandLine.Option(names={"--active-only"}, description={"Export only active (not redeemed/expired) vouchers"})
    boolean activeOnly;

    public ExportVouchersCmd(VoucherService service) {
        super(service);
    }

    @Override
    public void run() {
        if (!"json".equalsIgnoreCase(this.format)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Invalid format: " + this.format + ". Only 'json' is supported.");
        }
        WalletConfig config = WalletConfig.load();
        ((VoucherService)this.service).init(config);
        try {
            List<StoredVoucher> vouchers = ((VoucherService)this.service).listVouchers();
            if (this.activeOnly) {
                vouchers = vouchers.stream().filter(StoredVoucher::isActive).toList();
            }
            if (this.unit != null) {
                vouchers = vouchers.stream().filter(v -> v.unit().equals(this.unit)).toList();
            }
            Path outputFile = Paths.get(this.outputPath, new String[0]);
            this.exportToJson(vouchers, outputFile);
            System.out.println("\u2713 Exported " + vouchers.size() + " voucher(s) to " + String.valueOf(outputFile));
        }
        catch (IOException e) {
            System.err.println("\u274c Failed to export vouchers: " + e.getMessage());
            throw new CommandLine.ExecutionException(this.spec.commandLine(), "Failed to export vouchers to file: " + this.outputPath, e);
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to export vouchers: " + e.getMessage());
            throw new CommandLine.ExecutionException(this.spec.commandLine(), "Failed to export vouchers", e);
        }
    }

    private void exportToJson(List<StoredVoucher> vouchers, Path outputFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        if (outputFile.getParent() != null) {
            Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
        }
        mapper.writeValue(outputFile.toFile(), vouchers);
    }
}

