/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands.voucher;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.VoucherService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.state.StoredVoucher;

@CommandLine.Command(name="import", description={"Import vouchers from JSON file"})
public class ImportVouchersCmd
extends WalletServiceCommand<VoucherService> {
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"--format"}, description={"Import format (only 'json' supported)"}, required=true)
    String format;
    @CommandLine.Option(names={"--file"}, description={"Input file path"}, required=true)
    String filePath;
    @CommandLine.Option(names={"--skip-duplicates"}, description={"Skip vouchers that already exist in wallet"})
    boolean skipDuplicates;

    public ImportVouchersCmd(VoucherService service) {
        super(service);
    }

    @Override
    public void run() {
        if (!"json".equalsIgnoreCase(this.format)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Invalid format: " + this.format + ". Only 'json' is supported.");
        }
        Path inputFile = Paths.get(this.filePath, new String[0]);
        if (!Files.exists(inputFile, new LinkOption[0])) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Input file does not exist: " + this.filePath);
        }
        WalletConfig config = WalletConfig.load();
        ((VoucherService)this.service).init(config);
        try {
            List<StoredVoucher> vouchers = this.importFromJson(inputFile);
            List<StoredVoucher> existingVouchers = ((VoucherService)this.service).listVouchers();
            Set existingIds = existingVouchers.stream().map(StoredVoucher::voucherId).collect(Collectors.toSet());
            int imported = 0;
            int skipped = 0;
            for (StoredVoucher voucher : vouchers) {
                if (existingIds.contains(voucher.voucherId())) {
                    if (this.skipDuplicates) {
                        ++skipped;
                        continue;
                    }
                    System.err.println("\u26a0\ufe0f  Voucher " + voucher.voucherId() + " already exists in wallet");
                    ++skipped;
                    continue;
                }
                ((VoucherService)this.service).importVoucher(voucher);
                ++imported;
            }
            System.out.println("\u2713 Imported " + imported + " voucher(s) from " + String.valueOf(inputFile));
            if (skipped > 0) {
                System.out.println("  Skipped " + skipped + " duplicate voucher(s)");
            }
        }
        catch (IOException e) {
            System.err.println("\u274c Failed to import vouchers: " + e.getMessage());
            throw new CommandLine.ExecutionException(this.spec.commandLine(), "Failed to read vouchers from file: " + this.filePath, e);
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to import vouchers: " + e.getMessage());
            throw new CommandLine.ExecutionException(this.spec.commandLine(), "Failed to import vouchers", e);
        }
    }

    private List<StoredVoucher> importFromJson(Path inputFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readValue(inputFile.toFile(), new TypeReference<List<StoredVoucher>>(this){});
    }
}

