/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands.voucher;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.VoucherService;
import xyz.tcheeric.wallet.core.WalletConfig;

@CommandLine.Command(name="issue", description={"Issue a new voucher (gift card) and back it up to Nostr"})
public class IssueVoucherCmd
extends WalletServiceCommand<VoucherService> {
    @CommandLine.Option(names={"--json"}, description={"Output JSON"})
    boolean jsonOutput;
    @CommandLine.Option(names={"--amount"}, description={"Face value amount (sats)"}, required=true)
    long amount;
    @CommandLine.Option(names={"--unit"}, description={"Currency unit (default: sat)"})
    String unit = "sat";
    @CommandLine.Option(names={"--mint"}, description={"Mint URL (default: from config)"})
    String mint;
    @CommandLine.Option(names={"--expires"}, description={"Expiry in days (optional)"})
    Integer expiresInDays;
    @CommandLine.Option(names={"--memo"}, description={"Optional memo/description"})
    String memo;

    public IssueVoucherCmd(VoucherService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        String mintUrl = this.mint != null ? this.mint : config.defaultMintUrl();
        ((VoucherService)this.service).init(new WalletConfig(mintUrl, this.unit));
        try {
            VoucherService.IssueVoucherRequest request = new VoucherService.IssueVoucherRequest(this.amount, this.unit, mintUrl, this.expiresInDays, this.memo);
            VoucherService.IssueVoucherResult result = ((VoucherService)this.service).issueAndBackup(request);
            if (this.jsonOutput) {
                this.printJsonOutput(result);
            } else {
                this.printPlainOutput(result);
            }
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to issue voucher: " + e.getMessage());
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to issue voucher", e);
        }
    }

    private void printPlainOutput(VoucherService.IssueVoucherResult result) {
        System.out.println("\u2705 Voucher issued successfully");
        System.out.println();
        System.out.println("Voucher ID: " + result.voucher().voucherId());
        System.out.println("Amount:     " + result.voucher().faceValue() + " " + result.voucher().unit());
        if (result.voucher().expiresAt() != null) {
            System.out.println("Expires:    " + String.valueOf(Instant.ofEpochSecond(result.voucher().expiresAt())));
        }
        if (result.voucher().memo() != null) {
            System.out.println("Memo:       " + result.voucher().memo());
        }
        System.out.println("Status:     " + result.voucher().status());
        System.out.println("Backed up:  " + (result.backedUp() ? "Yes" : "No"));
        System.out.println();
        System.out.println("Token:");
        System.out.println(result.token());
    }

    private void printJsonOutput(VoucherService.IssueVoucherResult result) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            System.out.println(mapper.writeValueAsString(result));
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to serialize result to JSON", e);
        }
    }
}

