/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands.voucher;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.List;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.VoucherService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.state.StoredVoucher;

@CommandLine.Command(name="list", description={"List all vouchers in the wallet"})
public class ListVouchersCmd
extends WalletServiceCommand<VoucherService> {
    @CommandLine.Option(names={"--json"}, description={"Output JSON"})
    boolean jsonOutput;
    @CommandLine.Option(names={"--active-only"}, description={"Show only active (not redeemed/expired) vouchers"})
    boolean activeOnly;
    @CommandLine.Option(names={"--unit"}, description={"Filter by currency unit"})
    String unit;

    public ListVouchersCmd(VoucherService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        ((VoucherService)this.service).init(config);
        try {
            List<StoredVoucher> vouchers = ((VoucherService)this.service).listVouchers();
            if (this.activeOnly) {
                vouchers = vouchers.stream().filter(StoredVoucher::isActive).toList();
            }
            if (this.unit != null) {
                vouchers = vouchers.stream().filter(v -> v.unit().equals(this.unit)).toList();
            }
            if (this.jsonOutput) {
                this.printJsonOutput(vouchers);
            } else {
                this.printPlainOutput(vouchers);
            }
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to list vouchers: " + e.getMessage());
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to list vouchers", e);
        }
    }

    private void printPlainOutput(List<StoredVoucher> vouchers) {
        if (vouchers.isEmpty()) {
            System.out.println("No vouchers found");
            return;
        }
        System.out.println("Vouchers (" + vouchers.size() + " total):");
        System.out.println();
        for (StoredVoucher voucher : vouchers) {
            String status = this.formatStatus(voucher);
            String expiry = this.formatExpiry(voucher);
            String memo = voucher.memo() != null ? " | " + voucher.memo() : "";
            System.out.printf("%s | %d %s | %s%s%s%n", this.truncate(voucher.voucherId(), 16), voucher.faceValue(), voucher.unit(), status, expiry, memo);
        }
    }

    private void printJsonOutput(List<StoredVoucher> vouchers) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            System.out.println(mapper.writeValueAsString(vouchers));
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to serialize vouchers to JSON", e);
        }
    }

    private String formatStatus(StoredVoucher voucher) {
        if (voucher.isExpired()) {
            return "EXPIRED";
        }
        return voucher.status().toUpperCase();
    }

    private String formatExpiry(StoredVoucher voucher) {
        if (voucher.expiresAt() == null) {
            return "";
        }
        Instant expiry = Instant.ofEpochSecond(voucher.expiresAt());
        if (voucher.isExpired()) {
            return " | expired " + String.valueOf(expiry);
        }
        return " | expires " + String.valueOf(expiry);
    }

    private String truncate(String s, int maxLen) {
        if (s == null) {
            return "";
        }
        return s.length() > maxLen ? s.substring(0, maxLen) + "\u2026" : s;
    }
}

