/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands.voucher;

import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.VoucherService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.exception.WalletOperationException;

@CommandLine.Command(name="redeem", description={"Redeem a voucher (for merchants)"})
public class RedeemVoucherCmd
extends WalletServiceCommand<VoucherService> {
    @CommandLine.Parameters(index="0", description={"Voucher ID to redeem"})
    String voucherId;

    public RedeemVoucherCmd(VoucherService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        ((VoucherService)this.service).init(config);
        try {
            VoucherService.RedeemVoucherResult result = ((VoucherService)this.service).redeemVoucher(new VoucherService.RedeemVoucherRequest(this.voucherId));
            if ("already_redeemed".equalsIgnoreCase(result.status())) {
                System.out.println("\u2139 Voucher " + this.voucherId + " was already redeemed.");
            } else {
                System.out.println("\u2705 Voucher " + this.voucherId + " redeemed (" + result.status() + ").");
            }
            if (!result.ledgerUpdated()) {
                System.out.println("\u2139 " + result.message());
            } else {
                System.out.println(result.message());
            }
        }
        catch (WalletOperationException e) {
            throw new CommandLine.ExecutionException(new CommandLine(this), e.getMessage(), e);
        }
    }
}

