/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands.voucher;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.file.Files;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.VoucherService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.state.StoredVoucher;
import xyz.tcheeric.wallet.core.state.WalletStateJsonCodec;

@CommandLine.Command(name="restore", description={"Restore vouchers from Nostr backups or local JSON file"})
public class RestoreVouchersCmd
extends WalletServiceCommand<VoucherService> {
    @CommandLine.Option(names={"--nostr"}, defaultValue="true", description={"Restore vouchers from Nostr relays using NIP-17 encrypted DMs (default: true)"})
    private boolean nostr;
    @CommandLine.Option(names={"--file", "-f"}, description={"Restore vouchers from a local JSON backup file"})
    private File file;
    private final ObjectMapper objectMapper = WalletStateJsonCodec.newObjectMapper();

    public RestoreVouchersCmd(VoucherService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        ((VoucherService)this.service).init(config);
        try {
            int restoredCount;
            if (this.file != null) {
                restoredCount = this.restoreFromFile();
            } else if (this.nostr) {
                restoredCount = this.restoreFromNostr();
            } else {
                System.out.println("\u2139 No restore source specified. Use --nostr or --file <path>");
                return;
            }
            if (restoredCount == 0) {
                System.out.println("\u2139 No new vouchers found to restore");
            } else {
                System.out.println("\u2705 Restored " + restoredCount + " voucher(s)");
            }
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to restore vouchers: " + e.getMessage());
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to restore vouchers", e);
        }
    }

    private int restoreFromNostr() throws Exception {
        System.out.println("Restoring vouchers from Nostr...");
        try {
            return ((VoucherService)this.service).restoreFromNostr();
        }
        catch (UnsupportedOperationException e) {
            System.err.println("\u26a0 Nostr voucher restore not yet fully implemented");
            System.err.println(e.getMessage());
            System.err.println();
            System.err.println("This feature requires Nostr backup service integration.");
            System.err.println("Please check back in a future release.");
            throw e;
        }
    }

    private int restoreFromFile() throws Exception {
        System.out.println("Restoring vouchers from file: " + this.file.getAbsolutePath());
        if (!this.file.exists()) {
            throw new IllegalArgumentException("Backup file does not exist: " + this.file.getAbsolutePath());
        }
        if (!this.file.canRead()) {
            throw new IllegalArgumentException("Cannot read backup file: " + this.file.getAbsolutePath());
        }
        String jsonContent = Files.readString(this.file.toPath());
        StoredVoucher[] vouchers = this.objectMapper.readValue(jsonContent, StoredVoucher[].class);
        int imported = 0;
        int skipped = 0;
        for (StoredVoucher voucher : vouchers) {
            try {
                ((VoucherService)this.service).importVoucher(voucher);
                ++imported;
            }
            catch (Exception e) {
                ++skipped;
                System.err.println("\u26a0 Skipped voucher " + voucher.voucherId() + ": " + e.getMessage());
            }
        }
        if (skipped > 0) {
            System.out.println("\u2139 Skipped " + skipped + " voucher(s) (already exist or invalid)");
        }
        return imported;
    }
}

