/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands.voucher;

import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.VoucherService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.exception.WalletOperationException;

@CommandLine.Command(name="revoke", description={"Revoke a voucher (for issuers)"})
public class RevokeVoucherCmd
extends WalletServiceCommand<VoucherService> {
    @CommandLine.Parameters(index="0", description={"Voucher ID to revoke"})
    String voucherId;
    @CommandLine.Option(names={"-r", "--reason"}, description={"Reason for revocation"}, required=true)
    String reason;
    @CommandLine.Option(names={"--no-publish"}, description={"Skip publishing to Nostr ledger (local revocation only)"}, defaultValue="false")
    boolean noPublish;

    public RevokeVoucherCmd(VoucherService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        ((VoucherService)this.service).init(config);
        try {
            VoucherService.RevokeVoucherResult result = ((VoucherService)this.service).revokeVoucher(new VoucherService.RevokeVoucherRequest(this.voucherId, this.reason, !this.noPublish));
            if ("revoked".equalsIgnoreCase(result.previousStatus())) {
                System.out.println("\u2139 Voucher " + this.voucherId + " was already revoked.");
            } else {
                System.out.println("\u2705 Voucher " + this.voucherId + " revoked (was: " + result.previousStatus() + ").");
                System.out.println("   Reason: " + this.reason);
            }
            if (!result.ledgerPublished() && !this.noPublish) {
                System.out.println("\u2139 " + result.message());
            } else if (result.ledgerPublished()) {
                System.out.println("\u2139 Revocation published to Nostr ledger.");
            } else {
                System.out.println(result.message());
            }
        }
        catch (WalletOperationException e) {
            throw new CommandLine.ExecutionException(new CommandLine(this), e.getMessage(), e);
        }
    }
}

