/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands.voucher;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.Optional;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.VoucherService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.state.StoredVoucher;

@CommandLine.Command(name="show", description={"Show details of a specific voucher"})
public class ShowVoucherCmd
extends WalletServiceCommand<VoucherService> {
    @CommandLine.Option(names={"--json"}, description={"Output JSON"})
    boolean jsonOutput;
    @CommandLine.Parameters(index="0", description={"Voucher ID"})
    String voucherId;

    public ShowVoucherCmd(VoucherService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        ((VoucherService)this.service).init(config);
        try {
            Optional<StoredVoucher> voucherOpt = ((VoucherService)this.service).getVoucher(this.voucherId);
            if (voucherOpt.isEmpty()) {
                System.err.println("\u274c Voucher not found: " + this.voucherId);
                throw new CommandLine.ExecutionException(new CommandLine(this), "Voucher not found");
            }
            StoredVoucher voucher = voucherOpt.get();
            if (this.jsonOutput) {
                this.printJsonOutput(voucher);
            } else {
                this.printPlainOutput(voucher);
            }
        }
        catch (CommandLine.ExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to show voucher: " + e.getMessage());
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to show voucher", e);
        }
    }

    private void printPlainOutput(StoredVoucher voucher) {
        System.out.println("Voucher Details");
        System.out.println("===============");
        System.out.println();
        System.out.println("ID:              " + voucher.voucherId());
        System.out.println("Issuer:          " + voucher.issuerId());
        System.out.println("Amount:          " + voucher.faceValue() + " " + voucher.unit());
        System.out.println("Status:          " + this.formatStatus(voucher));
        System.out.println("Issued:          " + String.valueOf(voucher.issuedAt()));
        if (voucher.expiresAt() != null) {
            Instant expiry = Instant.ofEpochSecond(voucher.expiresAt());
            System.out.println("Expires:         " + String.valueOf(expiry) + (voucher.isExpired() ? " (EXPIRED)" : ""));
        } else {
            System.out.println("Expires:         Never");
        }
        if (voucher.memo() != null) {
            System.out.println("Memo:            " + voucher.memo());
        }
        System.out.println();
        System.out.println("Cryptographic Details");
        System.out.println("---------------------");
        System.out.println("Issuer Pubkey:   " + voucher.issuerPublicKey());
        System.out.println("Signature:       " + this.truncate(voucher.issuerSignature(), 32) + "\u2026");
        System.out.println();
        System.out.println("Active:          " + (voucher.isActive() ? "Yes" : "No"));
    }

    private void printJsonOutput(StoredVoucher voucher) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            System.out.println(mapper.writerWithDefaultPrettyPrinter().writeValueAsString(voucher));
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to serialize voucher to JSON", e);
        }
    }

    private String formatStatus(StoredVoucher voucher) {
        if (voucher.isExpired()) {
            return "EXPIRED";
        }
        return voucher.status().toUpperCase();
    }

    private String truncate(String s, int maxLen) {
        if (s == null) {
            return "";
        }
        return s.length() > maxLen ? s.substring(0, maxLen) : s;
    }
}

