/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.commands.voucher;

import java.util.Optional;
import picocli.CommandLine;
import xyz.tcheeric.wallet.cli.commands.WalletServiceCommand;
import xyz.tcheeric.wallet.core.VoucherService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.state.StoredVoucher;

@CommandLine.Command(name="verify", description={"Verify a voucher with Ed25519 signature validation (NUT-11)"})
public class VerifyVoucherCmd
extends WalletServiceCommand<VoucherService> {
    @CommandLine.Parameters(index="0", description={"Voucher ID to verify"})
    String voucherId;
    @CommandLine.Option(names={"--online"}, description={"Query Nostr ledger for online verification"})
    boolean online;

    public VerifyVoucherCmd(VoucherService service) {
        super(service);
    }

    @Override
    public void run() {
        WalletConfig config = WalletConfig.load();
        ((VoucherService)this.service).init(config);
        try {
            VoucherService.VerifyVoucherResult result = ((VoucherService)this.service).verifyVoucher(new VoucherService.VerifyVoucherRequest(this.voucherId));
            System.out.println("Cryptographic Verification");
            System.out.println("===========================");
            System.out.println("Voucher ID:       " + result.voucherId());
            System.out.println("Signature Valid:  " + (result.signatureValid() ? "Yes \u2705" : "No \u274c"));
            System.out.println("Expired:          " + (result.expired() ? "Yes \u274c" : "No \u2705"));
            System.out.println("Status:           " + result.status());
            if (this.online) {
                System.out.println();
                System.out.println("Online Verification");
                System.out.println("===================");
                try {
                    Optional<StoredVoucher> refreshed = ((VoucherService)this.service).refreshStatus(this.voucherId);
                    if (refreshed.isPresent()) {
                        StoredVoucher updated = refreshed.get();
                        System.out.println("Ledger Status: " + updated.status());
                        System.out.println("Valid:         " + (updated.isActive() ? "Yes \u2705" : "No \u274c"));
                    } else {
                        System.err.println("\u26a0 Could not query Nostr ledger");
                    }
                }
                catch (UnsupportedOperationException e) {
                    System.err.println("\u26a0 Online verification not yet implemented");
                    System.err.println(e.getMessage());
                }
            }
            System.out.println();
            if (result.isValid()) {
                System.out.println("\u2705 Voucher is VALID and can be redeemed");
            } else {
                System.out.println("\u274c Voucher is INVALID (cannot be redeemed)");
                System.out.println("   Reason: " + result.message());
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("\u274c Voucher not found: " + this.voucherId);
            throw new CommandLine.ExecutionException(new CommandLine(this), "Voucher not found", e);
        }
        catch (Exception e) {
            System.err.println("\u274c Failed to verify voucher: " + e.getMessage());
            throw new CommandLine.ExecutionException(new CommandLine(this), "Failed to verify voucher", e);
        }
    }
}

