/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.config;

import java.time.Duration;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.api.adapter.RestTemplateConfig;

public class MintApiClientConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MintApiClientConfig.class);
    public static final int DEFAULT_CONNECT_TIMEOUT_MS = 5000;
    public static final int DEFAULT_READ_TIMEOUT_MS = 30000;

    public static RestTemplateConfig fromSystemProperties() {
        int connectTimeout = MintApiClientConfig.getIntProperty("mint.api.connect-timeout", "MINT_API_CONNECT_TIMEOUT", 5000);
        int readTimeout = MintApiClientConfig.getIntProperty("mint.api.read-timeout", "MINT_API_READ_TIMEOUT", 30000);
        boolean loggingEnabled = MintApiClientConfig.getBooleanProperty("mint.api.logging.enabled", "MINT_API_LOGGING_ENABLED", true);
        boolean logRequestBody = MintApiClientConfig.getBooleanProperty("mint.api.logging.log-request-body", "MINT_API_LOGGING_LOG_REQUEST_BODY", false);
        boolean logResponseBody = MintApiClientConfig.getBooleanProperty("mint.api.logging.log-response-body", "MINT_API_LOGGING_LOG_RESPONSE_BODY", false);
        RestTemplateConfig config = RestTemplateConfig.builder().connectTimeout(Duration.ofMillis(connectTimeout)).readTimeout(Duration.ofMillis(readTimeout)).enableLogging(loggingEnabled).logRequestBody(logRequestBody).logResponseBody(logResponseBody).build();
        log.debug("mint_api_client_config loaded connect_timeout_ms={} read_timeout_ms={} logging_enabled={} log_request_body={} log_response_body={}", connectTimeout, readTimeout, loggingEnabled, logRequestBody, logResponseBody);
        return config;
    }

    private static int getIntProperty(String sysProp, String envVar, int defaultValue) {
        String envValue;
        String sysPropValue = System.getProperty(sysProp);
        if (sysPropValue != null) {
            try {
                return Integer.parseInt(sysPropValue);
            }
            catch (NumberFormatException e) {
                log.warn("mint_api_client_config invalid_int_property property={} value='{}' using_default={}", sysProp, sysPropValue, defaultValue);
            }
        }
        if ((envValue = System.getenv(envVar)) != null) {
            try {
                return Integer.parseInt(envValue);
            }
            catch (NumberFormatException e) {
                log.warn("mint_api_client_config invalid_int_env env={} value='{}' using_default={}", envVar, envValue, defaultValue);
            }
        }
        return defaultValue;
    }

    private static boolean getBooleanProperty(String sysProp, String envVar, boolean defaultValue) {
        String sysPropValue = System.getProperty(sysProp);
        if (sysPropValue != null) {
            return Boolean.parseBoolean(sysPropValue);
        }
        String envValue = System.getenv(envVar);
        if (envValue != null) {
            return Boolean.parseBoolean(envValue);
        }
        return defaultValue;
    }

    public static void logCurrentConfiguration() {
        RestTemplateConfig config = MintApiClientConfig.fromSystemProperties();
        log.info("mint_api_client_config current_settings connect_timeout={} read_timeout={} logging_enabled={} log_request_body={} log_response_body={}", config.getConnectTimeout(), config.getReadTimeout(), config.isEnableLogging(), config.isLogRequestBody(), config.isLogResponseBody());
    }
}

