/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SecretRedactionFilter
extends Filter<ILoggingEvent> {
    private static final Pattern BOLT11_PATTERN = Pattern.compile("\\b(lnbc|lntb|lnbcrt)[0-9a-z]{20,}", 2);
    private static final Pattern HEX_SECRET_PATTERN = Pattern.compile("(?i)(?:secret|key|private|seed|mnemonic)[\"']?\\s*[:=]?\\s*[\"']?([0-9a-fA-F]{64,})", 2);
    private static final Pattern PRIVATE_KEY_PATTERN = Pattern.compile("\\b[0-9a-fA-F]{64}\\b");
    private static final Pattern IP_ADDRESS_PATTERN = Pattern.compile("\\b(?:[0-9]{1,3}\\.){3}[0-9]{1,3}\\b");
    private static final Pattern CASHU_TOKEN_PATTERN = Pattern.compile("\\bcashuA[A-Za-z0-9+/=]{50,}", 2);
    private static final Pattern JWT_PATTERN = Pattern.compile("\\beyJ[A-Za-z0-9_-]+\\.[A-Za-z0-9_-]+\\.[A-Za-z0-9_-]+\\b");
    private static final String REDACTED = "[REDACTED]";
    private static final String REDACTED_IP = "[REDACTED_IP]";

    @Override
    public FilterReply decide(ILoggingEvent event) {
        return FilterReply.NEUTRAL;
    }

    public static String redact(String message) {
        Object replacement;
        if (message == null) {
            return null;
        }
        String redacted = message;
        Matcher bolt11Matcher = BOLT11_PATTERN.matcher(redacted);
        StringBuffer sb = new StringBuffer();
        while (bolt11Matcher.find()) {
            String invoice = bolt11Matcher.group();
            String replacement2 = invoice.substring(0, Math.min(8, invoice.length())) + REDACTED;
            bolt11Matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement2));
        }
        bolt11Matcher.appendTail(sb);
        redacted = sb.toString();
        Matcher hexSecretMatcher = HEX_SECRET_PATTERN.matcher(redacted);
        sb = new StringBuffer();
        while (hexSecretMatcher.find()) {
            String fullMatch = hexSecretMatcher.group(0);
            String hexValue = hexSecretMatcher.group(1);
            replacement = fullMatch.replace(hexValue, REDACTED);
            hexSecretMatcher.appendReplacement(sb, Matcher.quoteReplacement((String)replacement));
        }
        hexSecretMatcher.appendTail(sb);
        redacted = sb.toString();
        Matcher tokenMatcher = CASHU_TOKEN_PATTERN.matcher(redacted);
        sb = new StringBuffer();
        while (tokenMatcher.find()) {
            String token = tokenMatcher.group();
            replacement = token.substring(0, Math.min(8, token.length())) + REDACTED;
            tokenMatcher.appendReplacement(sb, Matcher.quoteReplacement((String)replacement));
        }
        tokenMatcher.appendTail(sb);
        redacted = sb.toString();
        Matcher jwtMatcher = JWT_PATTERN.matcher(redacted);
        sb = new StringBuffer();
        while (jwtMatcher.find()) {
            String jwt = jwtMatcher.group();
            String replacement3 = jwt.substring(0, Math.min(12, jwt.length())) + REDACTED;
            jwtMatcher.appendReplacement(sb, Matcher.quoteReplacement(replacement3));
        }
        jwtMatcher.appendTail(sb);
        redacted = sb.toString();
        redacted = PRIVATE_KEY_PATTERN.matcher(redacted).replaceAll(REDACTED);
        redacted = IP_ADDRESS_PATTERN.matcher(redacted).replaceAll(REDACTED_IP);
        return redacted;
    }
}

