/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.logging;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import java.util.UUID;
import org.slf4j.MDC;

public class TraceContext
implements AutoCloseable {
    private static final String TRACE_ID_KEY = "trace_id";
    private static final String SPAN_ID_KEY = "span_id";
    private final boolean isSpanOnly;

    public static TraceContext startTrace() {
        String traceId = TraceContext.getTraceIdFromOTel();
        if (traceId == null) {
            traceId = TraceContext.generateTraceId();
        }
        MDC.put(TRACE_ID_KEY, traceId);
        return new TraceContext();
    }

    private static String getTraceIdFromOTel() {
        try {
            SpanContext spanContext;
            Span currentSpan = Span.current();
            if (currentSpan != null && (spanContext = currentSpan.getSpanContext()).isValid()) {
                return spanContext.getTraceId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static TraceContext startTrace(String traceId) {
        MDC.put(TRACE_ID_KEY, traceId);
        return new TraceContext();
    }

    public static TraceContext startSpan(String spanId) {
        if (spanId != null) {
            MDC.put(SPAN_ID_KEY, spanId);
        } else {
            MDC.put(SPAN_ID_KEY, TraceContext.generateSpanId());
        }
        return new TraceContext(true);
    }

    public static String getCurrentTraceId() {
        return MDC.get(TRACE_ID_KEY);
    }

    public static String getCurrentSpanId() {
        return MDC.get(SPAN_ID_KEY);
    }

    private static String generateTraceId() {
        UUID uuid1 = UUID.randomUUID();
        UUID uuid2 = UUID.randomUUID();
        return String.format("%016x%016x", uuid1.getMostSignificantBits(), uuid2.getMostSignificantBits());
    }

    private static String generateSpanId() {
        UUID uuid = UUID.randomUUID();
        return String.format("%016x", uuid.getMostSignificantBits());
    }

    private TraceContext() {
        this(false);
    }

    private TraceContext(boolean isSpanOnly) {
        this.isSpanOnly = isSpanOnly;
    }

    @Override
    public void close() {
        if (this.isSpanOnly) {
            MDC.remove(SPAN_ID_KEY);
        } else {
            MDC.remove(TRACE_ID_KEY);
            MDC.remove(SPAN_ID_KEY);
        }
    }
}

