/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.mnemonic;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.bips.bip39.Bip39;
import xyz.tcheeric.bips.bip39.MnemonicValidator;
import xyz.tcheeric.wallet.core.crypto.AesMnemonicEncryption;
import xyz.tcheeric.wallet.core.state.WalletState;

public class MnemonicStorageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MnemonicStorageService.class);

    public WalletState storeMnemonic(WalletState currentState, String mnemonic, String passphrase) {
        if (currentState == null) {
            throw new IllegalArgumentException("Wallet state cannot be null. Suggestion: Initialize wallet state first.");
        }
        if (mnemonic == null || mnemonic.trim().isEmpty()) {
            throw new IllegalArgumentException("Mnemonic cannot be null or empty. Suggestion: Provide a valid BIP39 mnemonic phrase.");
        }
        if (passphrase == null) {
            throw new IllegalArgumentException("Passphrase cannot be null. Suggestion: Provide a passphrase (use empty string if none).");
        }
        try {
            String normalizedMnemonic = mnemonic.trim().replaceAll("\\s+", " ");
            MnemonicValidator.ValidationResult validation = Bip39.validateMnemonic(normalizedMnemonic);
            if (!validation.isValid()) {
                log.error("mnemonic_validation_failed error={}", (Object)validation.getErrorMessage());
                throw new MnemonicValidationException("Invalid BIP39 mnemonic: " + validation.getErrorMessage() + ". Suggestion: Verify the mnemonic was copied correctly.");
            }
            String encryptedMnemonic = AesMnemonicEncryption.encrypt(normalizedMnemonic, passphrase);
            log.info("mnemonic_stored deterministic_mode=true");
            return currentState.withEncryptedMnemonic(encryptedMnemonic);
        }
        catch (MnemonicValidationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("mnemonic_storage_failed error={}", (Object)e.getMessage(), (Object)e);
            throw new MnemonicStorageException("Failed to store mnemonic: " + e.getMessage() + ". Suggestion: Verify the mnemonic and passphrase, then try again.", e);
        }
    }

    public String retrieveMnemonic(WalletState currentState, String passphrase) {
        if (currentState == null) {
            throw new IllegalArgumentException("Wallet state cannot be null. Suggestion: Initialize wallet state first.");
        }
        if (passphrase == null) {
            throw new IllegalArgumentException("Passphrase cannot be null. Suggestion: Provide the passphrase used during storage.");
        }
        if (!currentState.hasMnemonic()) {
            log.debug("mnemonic_retrieval_failed reason=no_mnemonic_stored");
            return null;
        }
        try {
            String mnemonic = AesMnemonicEncryption.decrypt(currentState.encryptedMnemonic(), passphrase);
            log.info("mnemonic_retrieved successfully=true");
            return mnemonic;
        }
        catch (AesMnemonicEncryption.MnemonicDecryptionException e) {
            log.warn("mnemonic_retrieval_failed reason=decryption_failed");
            throw new MnemonicRetrievalException("Failed to retrieve mnemonic: incorrect passphrase or data corruption. Suggestion: Verify the passphrase is correct.", e);
        }
        catch (Exception e) {
            log.error("mnemonic_retrieval_failed error={}", (Object)e.getMessage(), (Object)e);
            throw new MnemonicRetrievalException("Failed to retrieve mnemonic: " + e.getMessage() + ". Suggestion: Verify wallet state integrity.", e);
        }
    }

    public boolean hasMnemonic(WalletState currentState) {
        if (currentState == null) {
            throw new IllegalArgumentException("Wallet state cannot be null. Suggestion: Initialize wallet state first.");
        }
        return currentState.hasMnemonic();
    }

    public boolean isDeterministic(WalletState currentState) {
        if (currentState == null) {
            throw new IllegalArgumentException("Wallet state cannot be null. Suggestion: Initialize wallet state first.");
        }
        return currentState.isDeterministic();
    }

    public static class MnemonicValidationException
    extends RuntimeException {
        public MnemonicValidationException(String message) {
            super(message);
        }
    }

    public static class MnemonicStorageException
    extends RuntimeException {
        public MnemonicStorageException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class MnemonicRetrievalException
    extends RuntimeException {
        public MnemonicRetrievalException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

