/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.nostr;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayService;
import xyz.tcheeric.wallet.core.nostr.NostrRelayOption;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.ports.TransferPublisher;

public class NostrTransferPublisher
implements TransferPublisher {
    private final NostrGatewayService gateway;

    public NostrTransferPublisher(NostrGatewayService gateway) {
        this.gateway = Objects.requireNonNull(gateway, "gateway");
    }

    @Override
    public TransferPublisher.PublishResult publishTransfer(NostrEvent event, Collection<String> relayUrls) {
        Objects.requireNonNull(event, "event");
        if (relayUrls == null || relayUrls.isEmpty()) {
            this.gateway.publish(event);
            return new TransferPublisher.PublishResult(event.id(), this.activeRelayUrls());
        }
        List<String> normalized = this.normalize(relayUrls);
        this.gateway.publish(event, normalized);
        return new TransferPublisher.PublishResult(event.id(), normalized);
    }

    @Override
    public TransferPublisher.PublishResult publishAck(NostrEvent event) {
        Objects.requireNonNull(event, "event");
        this.gateway.publish(event);
        return new TransferPublisher.PublishResult(event.id(), this.activeRelayUrls());
    }

    @Override
    public AutoCloseable openSubscription(Collection<String> relayUrls, NostrSubscription subscription, Consumer<NostrEvent> consumer) {
        Objects.requireNonNull(subscription, "subscription");
        Objects.requireNonNull(consumer, "consumer");
        if (relayUrls == null || relayUrls.isEmpty()) {
            return this.gateway.subscribe(subscription, consumer);
        }
        List<String> normalized = this.normalize(relayUrls);
        return this.gateway.subscribe(normalized, subscription, consumer);
    }

    @Override
    public List<String> activeRelayUrls() {
        return this.gateway.activeRelayOptions().stream().map(NostrRelayOption::url).map(url -> url.endsWith("/") ? url.substring(0, url.length() - 1) : url).collect(Collectors.toList());
    }

    @Override
    public String walletPublicKey() {
        return this.gateway.walletSigningKey().publicKeyHex();
    }

    private List<String> normalize(Collection<String> relayUrls) {
        return relayUrls.stream().filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).map(url -> url.endsWith("/") ? url.substring(0, url.length() - 1) : url).distinct().collect(Collectors.toList());
    }
}

