/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.cli.support;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import xyz.tcheeric.wallet.core.ports.WalletStorage;
import xyz.tcheeric.wallet.core.state.WalletState;

public final class InMemoryWalletStorage
implements WalletStorage {
    private final Map<String, WalletState> storage = new ConcurrentHashMap<String, WalletState>();

    @Override
    public Optional<WalletState> load(String walletId) {
        return Optional.ofNullable(this.storage.get(walletId));
    }

    @Override
    public void save(String walletId, WalletState state) {
        this.storage.put(walletId, state);
    }

    @Override
    public boolean delete(String walletId) {
        return this.storage.remove(walletId) != null;
    }

    @Override
    public boolean exists(String walletId) {
        return this.storage.containsKey(walletId);
    }

    @Override
    public String getStorageInfo() {
        return "in-memory (non-persistent)";
    }
}

