/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import xyz.tcheeric.wallet.core.StoragePaths;

public final class ClientConfig {
    private ClientConfig() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String apiVersion() {
        String env = System.getenv("WALLET_API_VERSION");
        if (env != null && !env.isBlank()) {
            return ClientConfig.normalizeVersion(env);
        }
        Path path = StoragePaths.configFile();
        if (!Files.exists(path, new LinkOption[0])) return "v1";
        Properties p = new Properties();
        try (FileInputStream is = new FileInputStream(path.toFile());){
            p.load(is);
            String v = p.getProperty("apiVersion");
            if (v == null) return "v1";
            if (v.isBlank()) return "v1";
            String string = ClientConfig.normalizeVersion(v);
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "v1";
    }

    public static String apiPrefix() {
        String v = ClientConfig.apiVersion();
        return v.startsWith("/") ? v : "/" + v;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String mintId() {
        String env = System.getenv("WALLET_MINT_ID");
        if (env != null && !env.isBlank()) {
            return env.trim();
        }
        Path path = StoragePaths.configFile();
        if (!Files.exists(path, new LinkOption[0])) return null;
        Properties p = new Properties();
        try (FileInputStream is = new FileInputStream(path.toFile());){
            p.load(is);
            String v = p.getProperty("mintId");
            if (v == null) return null;
            if (v.isBlank()) return null;
            String string = v.trim();
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String normalizeVersion(String v) {
        if ((v = v.trim()).startsWith("/")) {
            v = v.substring(1);
        }
        return v;
    }
}

