/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core;

import xyz.tcheeric.wallet.core.security.EncryptionException;
import xyz.tcheeric.wallet.core.security.EncryptionService;

public class EncryptionBootstrap {
    private final EncryptionService encryptionService;

    public EncryptionBootstrap(EncryptionService encryptionService) {
        this.encryptionService = encryptionService;
    }

    public void initialize(String passphrase) {
        this.encryptionService.load();
        if (this.encryptionService.isEnabled()) {
            if (passphrase == null || passphrase.isEmpty()) {
                throw new RuntimeException("WALLET_PASSPHRASE required to unlock encrypted wallet");
            }
            try {
                this.encryptionService.unlock(passphrase);
            }
            catch (EncryptionException e) {
                throw new RuntimeException("Failed to unlock wallet", e);
            }
        }
    }
}

