/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core;

import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpStatusCodeException;
import xyz.tcheeric.cashu.common.ActiveKeySet;
import xyz.tcheeric.cashu.common.BlindSignature;
import xyz.tcheeric.cashu.common.BlindedMessage;
import xyz.tcheeric.cashu.common.KeySet;
import xyz.tcheeric.cashu.common.KeysetId;
import xyz.tcheeric.cashu.common.Proof;
import xyz.tcheeric.cashu.common.PublicKey;
import xyz.tcheeric.cashu.common.RandomStringSecret;
import xyz.tcheeric.cashu.common.Signature;
import xyz.tcheeric.cashu.common.util.SplittingService;
import xyz.tcheeric.cashu.entities.rest.GetActiveKeySetsResponse;
import xyz.tcheeric.cashu.entities.rest.GetKeySetsResponse;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.cashu.entities.rest.PostSwapResponse;
import xyz.tcheeric.wallet.core.Balance;
import xyz.tcheeric.wallet.core.DatabaseMigrator;
import xyz.tcheeric.wallet.core.EncryptionBootstrap;
import xyz.tcheeric.wallet.core.MeltRequestContext;
import xyz.tcheeric.wallet.core.MeltService;
import xyz.tcheeric.wallet.core.MintingService;
import xyz.tcheeric.wallet.core.ReceiveService;
import xyz.tcheeric.wallet.core.SendService;
import xyz.tcheeric.wallet.core.StoragePaths;
import xyz.tcheeric.wallet.core.UnspentSummary;
import xyz.tcheeric.wallet.core.VerifySummary;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.WalletDatabaseConfig;
import xyz.tcheeric.wallet.core.WalletStorageException;
import xyz.tcheeric.wallet.core.api.MintApi;
import xyz.tcheeric.wallet.core.api.MintApiException;
import xyz.tcheeric.wallet.core.api.adapter.CashuWalletMintApi;
import xyz.tcheeric.wallet.core.api.adapter.RestTemplateFactory;
import xyz.tcheeric.wallet.core.crypto.BDHKECryptoAdapter;
import xyz.tcheeric.wallet.core.crypto.CryptoAdapter;
import xyz.tcheeric.wallet.core.db.DataSourceFactory;
import xyz.tcheeric.wallet.core.db.ProofRepository;
import xyz.tcheeric.wallet.core.domain.WalletAggregate;
import xyz.tcheeric.wallet.core.domain.WalletAggregateRepository;
import xyz.tcheeric.wallet.core.domain.events.DomainEvent;
import xyz.tcheeric.wallet.core.exception.InvalidChangeDetectedException;
import xyz.tcheeric.wallet.core.exception.LightningPaymentFailureException;
import xyz.tcheeric.wallet.core.exception.ProofImportException;
import xyz.tcheeric.wallet.core.exception.QuoteExpiredException;
import xyz.tcheeric.wallet.core.melt.InvalidChangeException;
import xyz.tcheeric.wallet.core.melt.LightningPaymentException;
import xyz.tcheeric.wallet.core.melt.MeltQuoteExpiredException;
import xyz.tcheeric.wallet.core.mint.MintService;
import xyz.tcheeric.wallet.core.proof.NewProof;
import xyz.tcheeric.wallet.core.proof.ProofRecord;
import xyz.tcheeric.wallet.core.proof.ProofSummary;
import xyz.tcheeric.wallet.core.security.EncryptionException;
import xyz.tcheeric.wallet.core.security.EncryptionService;
import xyz.tcheeric.wallet.core.util.QuoteExpiryDetector;
import xyz.tcheeric.wallet.core.validation.WalletRequestValidator;

public class H2WalletService
implements MintingService,
MeltService,
SendService,
ReceiveService,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(H2WalletService.class);
    private static final String DEFAULT_WALLET_ID = "default";
    private WalletConfig config;
    private final MintApi mintApi;
    private final CryptoAdapter crypto;
    private final EncryptionService encryptionService = new EncryptionService();
    private WalletDatabaseConfig dbConfig;
    private DataSource dataSource;
    private ProofRepository proofRepository;
    private WalletAggregateRepository aggregateRepository;
    private MintService mintService;
    private xyz.tcheeric.wallet.core.melt.MeltService meltService;
    private final WalletRequestValidator requestValidator;
    private final SplittingService splittingService = new SplittingService();

    public H2WalletService() {
        this(new CashuWalletMintApi(RestTemplateFactory.create()), new BDHKECryptoAdapter(), WalletDatabaseConfig.inMemory());
    }

    public H2WalletService(MintApi mintApi) {
        this(mintApi, new BDHKECryptoAdapter(), WalletDatabaseConfig.inMemory());
    }

    public H2WalletService(MintApi mintApi, CryptoAdapter crypto) {
        this(mintApi, crypto, WalletDatabaseConfig.inMemory());
    }

    public H2WalletService(MintApi mintApi, CryptoAdapter crypto, WalletDatabaseConfig dbConfig) {
        this(mintApi, crypto, dbConfig, WalletRequestValidator.usingDefaultProvider());
    }

    private H2WalletService(MintApi mintApi, CryptoAdapter crypto, WalletDatabaseConfig dbConfig, WalletRequestValidator requestValidator) {
        this.mintApi = mintApi;
        this.crypto = crypto;
        this.dbConfig = dbConfig;
        this.dataSource = this.newDataSource(dbConfig);
        this.requestValidator = Objects.requireNonNull(requestValidator, "requestValidator");
        this.proofRepository = new ProofRepository(this.dataSource, this.encryptionService);
        this.aggregateRepository = new WalletAggregateRepository(this.dataSource, this.proofRepository);
        this.mintService = new MintService(mintApi, crypto, this.proofRepository, this.encryptionService);
        this.meltService = new xyz.tcheeric.wallet.core.melt.MeltService(mintApi, crypto, this.proofRepository, this.encryptionService);
    }

    public EncryptionService getEncryptionService() {
        return this.encryptionService;
    }

    @Override
    public void consolidate(String unit, String mintUrl) {
        WalletAggregate aggregate = this.aggregateRepository.loadOrCreate(DEFAULT_WALLET_ID, mintUrl, unit);
        List<ProofRecord> proofs = this.proofRepository.listProofs(unit, mintUrl);
        if (proofs.isEmpty()) {
            log.info("h2_wallet_service consolidate skipped unit={} mint={} reason=no_proofs", (Object)unit, (Object)mintUrl);
            return;
        }
        SwapPlan plan = this.executeConsolidationSwap(mintUrl, unit, proofs);
        if (plan.changeProofs().isEmpty()) {
            log.info("h2_wallet_service consolidate skipped unit={} mint={} reason=already_binary", (Object)unit, (Object)mintUrl);
            return;
        }
        List<NewProof> newProofs = plan.changeProofs();
        this.aggregateRepository.save(aggregate, newProofs);
        this.aggregateRepository.markProofsSpent(aggregate, proofs);
        log.info("h2_wallet_service consolidate_success unit={} mint={} proof_count={}", unit, mintUrl, newProofs.size());
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void init(WalletConfig config) {
        this.config = config;
        Path home = StoragePaths.walletHome();
        this.dbConfig = WalletDatabaseConfig.forPath(home);
        this.validateMint();
        new DatabaseMigrator().migrate(this.dbConfig);
        String envPass = System.getenv("WALLET_PASSPHRASE");
        String sysPass = System.getProperty("WALLET_PASSPHRASE");
        String passphrase = envPass != null && !envPass.isEmpty() ? envPass : (sysPass != null ? sysPass : "");
        new EncryptionBootstrap(this.encryptionService).initialize(passphrase);
        if (this.dataSource != null) {
            DataSourceFactory.shutdown(this.dataSource);
        }
        this.dataSource = this.newDataSource(this.dbConfig);
        this.proofRepository = new ProofRepository(this.dataSource, this.encryptionService);
        this.aggregateRepository = new WalletAggregateRepository(this.dataSource, this.proofRepository);
        this.mintService = new MintService(this.mintApi, this.crypto, this.proofRepository, this.encryptionService);
        this.meltService = new xyz.tcheeric.wallet.core.melt.MeltService(this.mintApi, this.crypto, this.proofRepository, this.encryptionService);
    }

    private DataSource newDataSource(WalletDatabaseConfig cfg) {
        return DataSourceFactory.createDataSource(cfg.getJdbcUrl(), cfg.getUser(), cfg.getPass());
    }

    @Override
    public void close() {
        try {
            if (this.dataSource != null) {
                DataSourceFactory.shutdown(this.dataSource);
            }
        }
        catch (Exception e) {
            log.warn("h2_wallet_service datasource_shutdown_failed reason={}", (Object)e.getMessage());
        }
    }

    private void validateMint() {
        String mintUrl = this.config.defaultMintUrl();
        try {
            this.mintApi.info(mintUrl);
        }
        catch (MintApiException e) {
            if (this.shouldSkipMintInfoValidation(e)) {
                HttpStatusCodeException statusEx = (HttpStatusCodeException)e.getCause();
                int statusValue = statusEx.getStatusCode().value();
                log.warn("h2_wallet_service mint_info_validation mint={} status={} outcome=skipped reason={} detail={}", mintUrl, statusValue, statusEx.getStatusText(), H2WalletService.safeMessage(e));
                return;
            }
            log.error("h2_wallet_service mint_info_validation mint={} outcome=failed reason={} impact=abort_initialization", (Object)mintUrl, (Object)H2WalletService.safeMessage(e));
            throw new RuntimeException(this.buildMintValidationMessage(mintUrl, e), e);
        }
    }

    private boolean shouldSkipMintInfoValidation(MintApiException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof HttpStatusCodeException) {
            HttpStatusCodeException statusEx = (HttpStatusCodeException)cause;
            int status = statusEx.getStatusCode().value();
            return status == HttpStatus.NOT_FOUND.value() || status == HttpStatus.METHOD_NOT_ALLOWED.value() || status == HttpStatus.NOT_IMPLEMENTED.value() || status == HttpStatus.GONE.value();
        }
        return false;
    }

    private String buildMintValidationMessage(String mintUrl, MintApiException exception) {
        String message = exception.getMessage();
        if (message != null && !message.isBlank()) {
            return message;
        }
        return "Failed to validate mint " + mintUrl + ". Suggestion: Run `wallet info --mint " + mintUrl + "` to verify connectivity and that the mint supports /v1/info.";
    }

    private static String safeMessage(Throwable throwable) {
        if (throwable == null) {
            return "unknown";
        }
        String message = throwable.getMessage();
        return message == null || message.isBlank() ? throwable.getClass().getSimpleName() : message;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Balance balance() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void mint(long amount, String unit, String mintUrl) {
        this.mintService.mint(amount, unit, mintUrl);
    }

    @Override
    public void mintWithQuote(String quoteId, long amount, String unit, String mintUrl) {
        this.mintService.mintWithQuote(quoteId, amount, unit, mintUrl);
    }

    @Override
    public void melt(MeltRequestContext request) {
        this.meltService.melt(request);
    }

    @Override
    public SendService.SendLightningResult sendLightning(SendService.SendLightningRequest request) throws QuoteExpiredException, InvalidChangeDetectedException, LightningPaymentFailureException {
        this.requestValidator.validate(request);
        try {
            this.meltService.melt(new MeltRequestContext(request.amount(), request.unit(), request.invoice(), request.mintUrl()));
            return new SendService.SendLightningResult(SendService.SendLightningResult.LightningStatus.SUCCESS, "Paid invoice " + request.invoice());
        }
        catch (MeltQuoteExpiredException e) {
            throw new QuoteExpiredException(request.invoice(), Instant.now(), String.format("Quote expired before paying invoice %s", this.summarizeInvoice(request.invoice())), (Throwable)e);
        }
        catch (InvalidChangeException e) {
            throw new InvalidChangeDetectedException(String.format("Mint returned invalid change while paying invoice %s", this.summarizeInvoice(request.invoice())), e);
        }
        catch (LightningPaymentException e) {
            throw new LightningPaymentFailureException(String.format("Mint failed to settle Lightning invoice %s", this.summarizeInvoice(request.invoice())), true, e);
        }
        catch (MintApiException e) {
            if (QuoteExpiryDetector.isQuoteExpired(e)) {
                throw new QuoteExpiredException(request.invoice(), Instant.now(), String.format("Quote expired before paying invoice %s", this.summarizeInvoice(request.invoice())), (Throwable)e);
            }
            throw new LightningPaymentFailureException(String.format("Mint reported Lightning failure for invoice %s", this.summarizeInvoice(request.invoice())), true, e);
        }
        catch (RuntimeException e) {
            throw new LightningPaymentFailureException(String.format("Unexpected Lightning failure for invoice %s", this.summarizeInvoice(request.invoice())), false, e);
        }
    }

    @Override
    public SendService.PreparedP2pkSend prepareP2pkSend(SendService.P2pkSendRequest request) {
        WalletAggregate.ProofReservation reservation;
        this.requestValidator.validate(request);
        WalletAggregate aggregate = this.aggregateRepository.loadOrCreate(DEFAULT_WALLET_ID, request.mintUrl(), request.unit());
        try {
            reservation = aggregate.reserveProofs(request.amount(), "p2pk-send");
        }
        catch (WalletAggregate.InsufficientProofsException e) {
            throw new IllegalStateException("Insufficient funds: " + e.getMessage(), e);
        }
        List<ProofRecord> reservedProofs = List.copyOf(reservation.toProofRecords(request.mintUrl(), request.unit()));
        PreparedSendContext sendContext = this.buildSendContext(request, reservedProofs, reservation.totalAmount());
        ArrayList<DomainEvent> events = new ArrayList<DomainEvent>(aggregate.getUncommittedEvents());
        AtomicBoolean finalized = new AtomicBoolean(false);
        Runnable commit = () -> {
            if (!finalized.compareAndSet(false, true)) {
                return;
            }
            if (sendContext.swapInvolved()) {
                this.completeSwapCommit(aggregate, reservation, reservedProofs, sendContext.changeProofs(), events);
            } else {
                this.completeExactCommit(aggregate, reservation, reservedProofs, events);
            }
        };
        Runnable cancel = () -> {
            if (!finalized.compareAndSet(false, true)) {
                return;
            }
            if (sendContext.swapInvolved()) {
                this.rollbackSwap(aggregate, reservation, reservedProofs, sendContext.rollbackProofs(), events);
            } else {
                aggregate.cancelReservation(reservation.reservationId());
            }
        };
        return new SendService.PreparedP2pkSend(sendContext.proofsForSend(), sendContext.totalAmount(), commit, cancel, events);
    }

    private PreparedSendContext buildSendContext(SendService.P2pkSendRequest request, List<ProofRecord> reservedProofs, long reservedTotal) {
        long target = request.amount();
        if (reservedTotal == target) {
            return PreparedSendContext.exactMatch(reservedProofs, target);
        }
        if (reservedTotal < target) {
            throw new IllegalStateException("Insufficient funds selected for swap: have " + reservedTotal + ", need " + target);
        }
        SwapPlan plan = this.executeSwapPlan(request, reservedProofs, reservedTotal);
        return PreparedSendContext.swap(plan.proofsForSend(), plan.changeProofs(), plan.rollbackProofs(), target);
    }

    private void completeExactCommit(WalletAggregate aggregate, WalletAggregate.ProofReservation reservation, List<ProofRecord> reservedProofs, List<DomainEvent> events) {
        aggregate.commitReservation(reservation.reservationId());
        this.aggregateRepository.save(aggregate, Collections.emptyList());
        this.aggregateRepository.markProofsSpent(aggregate, reservedProofs);
        events.addAll(aggregate.collectUncommittedEvents());
    }

    private void completeSwapCommit(WalletAggregate aggregate, WalletAggregate.ProofReservation reservation, List<ProofRecord> reservedProofs, List<NewProof> changeProofs, List<DomainEvent> events) {
        aggregate.commitReservation(reservation.reservationId());
        List<NewProof> imported = this.importIntoAggregate(aggregate, changeProofs);
        this.aggregateRepository.save(aggregate, imported);
        this.aggregateRepository.markProofsSpent(aggregate, reservedProofs);
        events.addAll(aggregate.collectUncommittedEvents());
    }

    private void rollbackSwap(WalletAggregate aggregate, WalletAggregate.ProofReservation reservation, List<ProofRecord> reservedProofs, List<NewProof> rollbackProofs, List<DomainEvent> events) {
        aggregate.commitReservation(reservation.reservationId());
        List<NewProof> imported = this.importIntoAggregate(aggregate, rollbackProofs);
        this.aggregateRepository.save(aggregate, imported);
        this.aggregateRepository.markProofsSpent(aggregate, reservedProofs);
        events.addAll(aggregate.collectUncommittedEvents());
    }

    private List<NewProof> importIntoAggregate(WalletAggregate aggregate, List<NewProof> proofs) {
        if (proofs.isEmpty()) {
            return Collections.emptyList();
        }
        WalletAggregate.ImportResult result = aggregate.importProofs(proofs);
        ArrayList<NewProof> importedProofs = new ArrayList<NewProof>();
        for (Long tempId : result.importedIds()) {
            int idx = Math.abs(tempId.intValue()) - 1;
            if (idx < 0 || idx >= proofs.size()) continue;
            importedProofs.add(proofs.get(idx));
        }
        return importedProofs;
    }

    private SwapPlan executeSwapPlan(SendService.P2pkSendRequest request, List<ProofRecord> reservedProofs, long reservedTotal) {
        KeysetInfo keyset = this.lookupActiveKeyset(request.mintUrl(), request.unit());
        List<Proof<RandomStringSecret>> inputs = this.toSwapInputs(reservedProofs);
        SwapExecution execution = this.performSwap(request.mintUrl(), keyset, reservedTotal, request.amount(), inputs);
        List<SwapProof> swapProofs = this.processSwapResults(execution, keyset);
        return this.partitionSwapOutputs(request, swapProofs, execution.sendProofCount());
    }

    private SwapPlan executeConsolidationSwap(String mintUrl, String unit, List<ProofRecord> proofs) {
        long total = proofs.stream().mapToLong(ProofRecord::amount).sum();
        KeysetInfo keyset = this.lookupActiveKeyset(mintUrl, unit);
        List<Proof<RandomStringSecret>> inputs = this.toSwapInputs(proofs);
        SwapExecution execution = this.performSwap(mintUrl, keyset, total, total, inputs);
        List<SwapProof> swapProofs = this.processSwapResults(execution, keyset);
        List<NewProof> consolidated = swapProofs.stream().map(SwapProof::toNewProof).toList();
        return new SwapPlan(List.of(), consolidated, consolidated);
    }

    private List<Proof<RandomStringSecret>> toSwapInputs(List<ProofRecord> proofs) {
        ArrayList<Proof<RandomStringSecret>> inputs = new ArrayList<Proof<RandomStringSecret>>(proofs.size());
        for (ProofRecord record : proofs) {
            Proof<RandomStringSecret> proof = new Proof<RandomStringSecret>();
            proof.setAmount(record.amount());
            proof.setKeySetId(record.keysetId());
            proof.setSecret(RandomStringSecret.fromBytes(record.secret()));
            try {
                proof.setUnblindedSignature(this.signatureFromHex(record.cHex()));
            }
            catch (RuntimeException e) {
                log.error("h2_wallet_service swap_input_signature_invalid amount={} keyset_id={} reason={}", record.amount(), record.keysetId(), e.getMessage(), e);
                throw e;
            }
            inputs.add(proof);
        }
        return inputs;
    }

    private SwapExecution performSwap(String mintUrl, KeysetInfo keyset, long reservedTotal, long target, List<Proof<RandomStringSecret>> inputs) {
        long change = reservedTotal - target;
        Set<Integer> availableDenoms = keyset.pubByAmount().keySet();
        List<Integer> sendDenoms = this.splittingService.split(target, availableDenoms);
        ArrayList<Integer> outDenoms = new ArrayList<Integer>(sendDenoms);
        if (change > 0L) {
            outDenoms.addAll(this.splittingService.split(change, availableDenoms));
        }
        ArrayList<BlindedMessage> blindedMessages = new ArrayList<BlindedMessage>(outDenoms.size());
        ArrayList<RandomStringSecret> outSecrets = new ArrayList<RandomStringSecret>(outDenoms.size());
        ArrayList<byte[]> outR = new ArrayList<byte[]>(outDenoms.size());
        Iterator iterator2 = outDenoms.iterator();
        while (iterator2.hasNext()) {
            int amount = (Integer)iterator2.next();
            RandomStringSecret secret = RandomStringSecret.create();
            outSecrets.add(secret);
            byte[][] blind = this.crypto.blindMessage(secret.getData());
            byte[] blinded = blind[0];
            byte[] r = blind[1];
            outR.add(r);
            BlindedMessage message = BlindedMessage.builder().amount(amount).keySetId(KeysetId.fromString(keyset.keysetId())).blindedMessage(PublicKey.fromBytes(blinded, false)).build();
            blindedMessages.add(message);
        }
        PostSwapRequest swapRequest = new PostSwapRequest(inputs, blindedMessages);
        PostSwapResponse swapResponse = this.mintApi.swap(mintUrl, swapRequest);
        return new SwapExecution(swapResponse, outSecrets, outR, outDenoms, sendDenoms.size());
    }

    private KeysetInfo lookupActiveKeyset(String mintUrl, String unit) {
        GetActiveKeySetsResponse activeKeySetsResponse = this.mintApi.activeKeysets(mintUrl);
        String keysetId = activeKeySetsResponse.getActiveKeySets().stream().filter(k -> unit.equalsIgnoreCase(k.getUnit()) && k.isActive()).map(ActiveKeySet::getId).findFirst().orElseThrow(() -> new IllegalStateException("No active keyset for unit " + unit));
        GetKeySetsResponse keysetResp = this.mintApi.keyset(mintUrl, keysetId);
        KeySet keyset = keysetResp.getKeySets().stream().filter(k -> keysetId.equals(k.getId())).findFirst().orElseThrow(() -> new IllegalStateException("Keyset not found: " + keysetId));
        HashMap<Integer, byte[]> pubByAmount = new HashMap<Integer, byte[]>();
        keyset.getKeys().getValues().forEach((amount, key) -> pubByAmount.put(amount.intValue(), key.toBytes()));
        return new KeysetInfo(keysetId, pubByAmount);
    }

    private List<SwapProof> processSwapResults(SwapExecution execution, KeysetInfo keyset) {
        ArrayList<SwapProof> proofs = new ArrayList<SwapProof>();
        List<BlindSignature> signatures = execution.swapResp().getBlindSignatures();
        for (int i2 = 0; i2 < signatures.size(); ++i2) {
            BlindSignature blindSignature = signatures.get(i2);
            int amount = blindSignature.getAmount();
            byte[] blinded = blindSignature.getBlindedSignature().getBytes();
            byte[] r = execution.outR().get(i2);
            byte[] pub = keyset.pubByAmount().get(amount);
            if (pub == null) {
                throw new IllegalStateException("Missing mint pubkey for amount " + amount);
            }
            byte[] unblinded = this.crypto.unblindSignature(blinded, r, pub);
            String cHex = H2WalletService.bytesToHex(unblinded);
            log.debug("h2_wallet_service swap_signature_unblinded amount={} signature_preview={} byte_length={}", amount, H2WalletService.redactSignature(cHex), unblinded == null ? -1 : unblinded.length);
            byte[] plaintextSecret = (byte[])execution.outSecrets().get(i2).getData().clone();
            byte[] encryptedSecret = this.encryptSecretCopy(plaintextSecret);
            proofs.add(new SwapProof(amount, cHex, plaintextSecret, encryptedSecret, keyset.keysetId()));
        }
        int expected = execution.outDenoms().stream().mapToInt(Integer::intValue).sum();
        int actual = proofs.stream().mapToInt(SwapProof::amount).sum();
        if (actual != expected) {
            throw new InvalidChangeException("Invalid change detected. Swap returned " + actual + " sats but expected " + expected + ". Suggestion: Retry the swap; if the issue continues, contact the mint operator before spending affected proofs.");
        }
        return proofs;
    }

    private SwapPlan partitionSwapOutputs(SendService.P2pkSendRequest request, List<SwapProof> proofs, int sendProofCount) {
        ArrayList<ProofRecord> sendProofs = new ArrayList<ProofRecord>();
        ArrayList<NewProof> changeProofs = new ArrayList<NewProof>();
        ArrayList<NewProof> rollbackProofs = new ArrayList<NewProof>();
        long sendSum = 0L;
        long target = request.amount();
        for (int i2 = 0; i2 < proofs.size(); ++i2) {
            boolean belongsToSend;
            SwapProof proof = proofs.get(i2);
            boolean bl = belongsToSend = i2 < sendProofCount && sendSum < target;
            if (belongsToSend) {
                sendProofs.add(proof.toProofRecord(request.mintUrl(), request.unit()));
                sendSum += (long)proof.amount();
            } else {
                changeProofs.add(proof.toNewProof());
            }
            rollbackProofs.add(proof.toNewProof());
        }
        if (sendSum != target) {
            throw new IllegalStateException("Swap returned " + sendSum + " sats for send but expected " + target);
        }
        return new SwapPlan(List.copyOf(sendProofs), List.copyOf(changeProofs), List.copyOf(rollbackProofs));
    }

    private byte[] encryptSecretCopy(byte[] plaintext) {
        byte[] copy = (byte[])plaintext.clone();
        try {
            return this.encryptionService.encrypt(copy);
        }
        catch (EncryptionException e) {
            return copy;
        }
    }

    private static byte[] hexToBytes(String hexString) {
        int len = hexString.length();
        byte[] bytes = new byte[len / 2];
        for (int i2 = 0; i2 < len; i2 += 2) {
            bytes[i2 / 2] = (byte)((Character.digit(hexString.charAt(i2), 16) << 4) + Character.digit(hexString.charAt(i2 + 1), 16));
        }
        return bytes;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789abcdef".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private Signature signatureFromHex(String hex) {
        if (hex == null) {
            throw new IllegalArgumentException("signature hex is null");
        }
        String normalized = hex.toLowerCase();
        if (normalized.length() == 66 && (normalized.startsWith("02") || normalized.startsWith("03"))) {
            return Signature.fromString(normalized);
        }
        if (normalized.length() == 128) {
            return Signature.fromBytes(H2WalletService.hexToBytes(normalized));
        }
        throw new IllegalArgumentException("signature hex length invalid");
    }

    private static String redactSignature(String hex) {
        if (hex == null || hex.isBlank()) {
            return "(redacted)";
        }
        return hex.length() <= 12 ? hex : hex.substring(0, 12) + "...";
    }

    public List<ProofSummary> listProofSummaries(String unit, String mintUrl, Integer minAmount, Integer maxAmount, String keysetId, boolean includeSpent, int limit) {
        return this.proofRepository.listProofSummaries(unit, mintUrl, minAmount, maxAmount, keysetId, includeSpent, limit);
    }

    public List<String> listUnits(String mintUrl) {
        ArrayList<String> units = new ArrayList<String>();
        try (Connection connection = DriverManager.getConnection(this.dbConfig.getJdbcUrl(), this.dbConfig.getUser(), this.dbConfig.getPass());
             PreparedStatement statement = connection.prepareStatement("SELECT DISTINCT unit FROM proofs WHERE spent=FALSE AND mint_url=? ORDER BY unit");){
            statement.setString(1, mintUrl);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    units.add(resultSet.getString(1));
                }
            }
        }
        catch (SQLException e) {
            throw new WalletStorageException("Failed to list units", e);
        }
        return units;
    }

    private String summarizeInvoice(String invoice) {
        if (invoice == null) {
            return "(unknown)";
        }
        if (invoice.length() <= 16) {
            return invoice;
        }
        return invoice.substring(0, 16) + "\u2026";
    }

    @Override
    public ReceiveService.ImportResult importProofs(ReceiveService.ImportRequest request) throws ProofImportException {
        this.requestValidator.validate(request);
        Objects.requireNonNull(request, "request");
        try {
            List<NewProof> original = request.proofs();
            ArrayList<NewProof> encrypted = new ArrayList<NewProof>(original.size());
            for (NewProof proof : original) {
                byte[] secret = proof.secret();
                if (secret != null && secret.length > 0) {
                    try {
                        secret = this.encryptionService.encrypt(secret);
                    }
                    catch (EncryptionException encryptionException) {
                        // empty catch block
                    }
                }
                encrypted.add(new NewProof(proof.amount(), proof.cHex(), secret, proof.keysetId()));
            }
            WalletAggregate aggregate = this.aggregateRepository.loadOrCreate(DEFAULT_WALLET_ID, request.mintUrl(), request.unit());
            WalletAggregate.ImportResult aggregateResult = aggregate.importProofs(encrypted);
            ArrayList<NewProof> newProofs = new ArrayList<NewProof>();
            for (Long tempId : aggregateResult.importedIds()) {
                int index = Math.abs(tempId.intValue()) - 1;
                if (index < 0 || index >= encrypted.size()) continue;
                newProofs.add((NewProof)encrypted.get(index));
            }
            if (!newProofs.isEmpty()) {
                this.aggregateRepository.save(aggregate, newProofs);
            }
            long importedAmount = 0L;
            long duplicateAmount = 0L;
            for (int i2 = 0; i2 < encrypted.size(); ++i2) {
                NewProof proof = original.get(i2);
                if (aggregateResult.importedIds().contains(-((long)i2 + 1L))) {
                    importedAmount += (long)proof.amount();
                    continue;
                }
                duplicateAmount += (long)proof.amount();
            }
            List<DomainEvent> events = aggregate.collectUncommittedEvents();
            return new ReceiveService.ImportResult(aggregateResult.importedCount(), aggregateResult.duplicateCount(), importedAmount, duplicateAmount, events);
        }
        catch (WalletStorageException e) {
            throw new ProofImportException(String.format("Failed to persist proofs imported from %s", request.mintUrl()), e);
        }
        catch (IllegalArgumentException e) {
            throw new ProofImportException(String.format("Invalid proof import data received from %s", request.mintUrl()), e);
        }
    }

    public void changeEncryptionPassphrase(String unit, String mintUrl, String current, String next, String kdf) {
        this.encryptionService.load();
        if (!this.encryptionService.isEnabled()) {
            throw new RuntimeException("Encryption not enabled");
        }
        try {
            if (kdf != null && !kdf.isBlank()) {
                this.encryptionService.changePassphraseWithKdf(current, next, kdf);
            } else {
                this.encryptionService.changePassphrase(current, next);
            }
        }
        catch (EncryptionException e) {
            throw new RuntimeException("Failed to change encryption passphrase", e);
        }
    }

    public void migrateToEncryption(String unit, String mintUrl, String passphrase) {
    }

    public VerifySummary verifyEncryption(String unit, String mintUrl, boolean fix) {
        this.encryptionService.load();
        if (!this.encryptionService.isEnabled()) {
            return new VerifySummary(0, 0, 0);
        }
        int total = 0;
        int encrypted = 0;
        int plaintext = 0;
        try (Connection c = DriverManager.getConnection(this.dbConfig.getJdbcUrl(), this.dbConfig.getUser(), this.dbConfig.getPass());
             PreparedStatement sel = c.prepareStatement("SELECT id, secret_enc FROM proofs WHERE unit=? AND mint_url=?");
             PreparedStatement upd = c.prepareStatement("UPDATE proofs SET secret_enc=? WHERE id=?");){
            block32: {
                sel.setString(1, unit);
                sel.setString(2, mintUrl);
                ResultSet rs = sel.executeQuery();
                block24: while (true) {
                    while (rs.next()) {
                        ++total;
                        long id = rs.getLong(1);
                        byte[] blob = rs.getBytes(2);
                        try {
                            this.encryptionService.decrypt(blob);
                            ++encrypted;
                            continue block24;
                        }
                        catch (Exception e) {
                            ++plaintext;
                            if (!fix) continue;
                            byte[] enc = this.encryptionService.encrypt(blob);
                            upd.setBytes(1, enc);
                            upd.setLong(2, id);
                            upd.addBatch();
                        }
                    }
                    break block32;
                    {
                        continue block24;
                        break;
                    }
                    break;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            if (fix) {
                upd.executeBatch();
                c.commit();
            }
        }
        catch (SQLException | EncryptionException e) {
            throw new WalletStorageException("Failed to verify encryption", e);
        }
        return new VerifySummary(total, encrypted, plaintext);
    }

    @Override
    public UnspentSummary status(String unit, String mintUrl) {
        UnspentSummary unspentSummary;
        block36: {
            long total = 0L;
            HashMap<Integer, Long> byAmount = new HashMap<Integer, Long>();
            Connection connection = DriverManager.getConnection(this.dbConfig.getJdbcUrl(), this.dbConfig.getUser(), this.dbConfig.getPass());
            try {
                ResultSet resultSet;
                try (PreparedStatement statement = connection.prepareStatement("SELECT COALESCE(SUM(amount),0) FROM proofs WHERE spent=FALSE AND unit=? AND mint_url=?");){
                    statement.setString(1, unit);
                    statement.setString(2, mintUrl);
                    resultSet = statement.executeQuery();
                    try {
                        if (resultSet.next()) {
                            total = resultSet.getLong(1);
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                statement = connection.prepareStatement("SELECT amount, COUNT(*) FROM proofs WHERE spent=FALSE AND unit=? AND mint_url=? GROUP BY amount ORDER BY amount");
                try {
                    statement.setString(1, unit);
                    statement.setString(2, mintUrl);
                    resultSet = statement.executeQuery();
                    try {
                        while (resultSet.next()) {
                            byAmount.put(resultSet.getInt(1), resultSet.getLong(2));
                        }
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
                unspentSummary = new UnspentSummary(total, byAmount);
                if (connection == null) break block36;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new WalletStorageException("Failed to compute status", e);
                }
            }
            connection.close();
        }
        return unspentSummary;
    }

    private record SwapPlan(List<ProofRecord> proofsForSend, List<NewProof> changeProofs, List<NewProof> rollbackProofs) {
    }

    private record PreparedSendContext(List<ProofRecord> proofsForSend, List<NewProof> changeProofs, List<NewProof> rollbackProofs, long totalAmount, boolean swapInvolved) {
        static PreparedSendContext exactMatch(List<ProofRecord> proofs, long totalAmount) {
            return new PreparedSendContext(List.copyOf(proofs), List.of(), List.of(), totalAmount, false);
        }

        static PreparedSendContext swap(List<ProofRecord> proofs, List<NewProof> changeProofs, List<NewProof> rollbackProofs, long totalAmount) {
            return new PreparedSendContext(List.copyOf(proofs), List.copyOf(changeProofs), List.copyOf(rollbackProofs), totalAmount, true);
        }
    }

    private record KeysetInfo(String keysetId, Map<Integer, byte[]> pubByAmount) {
    }

    private record SwapExecution(PostSwapResponse swapResp, List<RandomStringSecret> outSecrets, List<byte[]> outR, List<Integer> outDenoms, int sendProofCount) {
    }

    private record SwapProof(int amount, String cHex, byte[] plaintextSecret, byte[] encryptedSecret, String keysetId) {
        SwapProof {
            plaintextSecret = (byte[])plaintextSecret.clone();
            encryptedSecret = (byte[])encryptedSecret.clone();
        }

        NewProof toNewProof() {
            return new NewProof(this.amount, this.cHex, (byte[])this.encryptedSecret.clone(), this.keysetId);
        }

        ProofRecord toProofRecord(String mintUrl, String unit) {
            return new ProofRecord(-1L, mintUrl, unit, this.amount, this.cHex, (byte[])this.plaintextSecret.clone(), this.keysetId);
        }
    }
}

