/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.WalletStorageException;
import xyz.tcheeric.wallet.core.ports.WalletStorage;
import xyz.tcheeric.wallet.core.state.SchemaVersion;
import xyz.tcheeric.wallet.core.state.StoredVoucher;
import xyz.tcheeric.wallet.core.state.WalletSchemaMetadata;
import xyz.tcheeric.wallet.core.state.WalletState;

public final class H2WalletStorageAdapter
implements WalletStorage {
    private static final Logger log = LoggerFactory.getLogger(H2WalletStorageAdapter.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Supplier<DataSource> dataSourceSupplier;
    private final Object schemaLock = new Object();
    private final AtomicReference<DataSource> initializedDataSource = new AtomicReference();

    public H2WalletStorageAdapter(DataSource dataSource) {
        this(() -> dataSource);
    }

    public H2WalletStorageAdapter(Supplier<DataSource> dataSourceSupplier) {
        this.dataSourceSupplier = Objects.requireNonNull(dataSourceSupplier, "dataSourceSupplier");
    }

    private DataSource currentDataSource() {
        DataSource dataSource = this.dataSourceSupplier.get();
        if (dataSource == null) {
            throw new WalletStorageException("Failed to obtain wallet datasource. Reason: DataSource not initialized. Suggestion: Re-run the wallet command after wallet initialization completes.", new IllegalStateException("Wallet DataSource not initialized"));
        }
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSchemaInitialized(DataSource dataSource) {
        DataSource initialized = this.initializedDataSource.get();
        if (initialized == dataSource && initialized != null) {
            return;
        }
        Object object = this.schemaLock;
        synchronized (object) {
            initialized = this.initializedDataSource.get();
            if (initialized == dataSource && initialized != null) {
                return;
            }
            this.ensureVouchersTable(dataSource);
            this.initializedDataSource.set(dataSource);
        }
    }

    @Override
    public Optional<WalletState> load(String walletId) {
        Optional<WalletState> optional;
        block8: {
            log.debug("h2_storage_adapter loading wallet_id={}", (Object)walletId);
            DataSource dataSource = this.currentDataSource();
            this.ensureSchemaInitialized(dataSource);
            Connection conn = dataSource.getConnection();
            try {
                List<StoredVoucher> vouchers = this.loadVouchers(conn, walletId);
                log.info("h2_storage_adapter loaded wallet_id={} vouchers={}", (Object)walletId, (Object)vouchers.size());
                SchemaVersion v1_0 = SchemaVersion.V1_0;
                WalletSchemaMetadata schema = new WalletSchemaMetadata(v1_0, v1_0, v1_0, List.of(v1_0), List.of(v1_0));
                WalletState state = new WalletState(schema, Instant.now(), List.of(), List.of(), List.of(), null, null, null, vouchers, null);
                optional = Optional.of(state);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.error("h2_storage_adapter load_failed wallet_id={} error={}", walletId, e.getMessage(), e);
                    throw new WalletStorageException("Failed to load wallet state from H2 database. Cause: " + e.getMessage() + ". Suggestion: Retry the command or rerun `wallet init` to refresh the database state.", e);
                }
            }
            conn.close();
        }
        return optional;
    }

    @Override
    public void save(String walletId, WalletState state) {
        log.debug("h2_storage_adapter saving wallet_id={} vouchers={}", (Object)walletId, (Object)state.vouchers().size());
        DataSource dataSource = this.currentDataSource();
        this.ensureSchemaInitialized(dataSource);
        try (Connection conn = dataSource.getConnection();){
            conn.setAutoCommit(false);
            try {
                this.saveVouchers(conn, walletId, state.vouchers());
                conn.commit();
                log.info("h2_storage_adapter saved wallet_id={} vouchers={}", (Object)walletId, (Object)state.vouchers().size());
            }
            catch (SQLException e) {
                try {
                    conn.rollback();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw e;
            }
            finally {
                try {
                    conn.setAutoCommit(true);
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException e) {
            log.error("h2_storage_adapter save_failed wallet_id={} error={}", walletId, e.getMessage(), e);
            throw new WalletStorageException("Failed to save wallet state to H2 database. Cause: " + e.getMessage() + ". Suggestion: Retry the command or run `wallet status` to verify database health.", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(String walletId) {
        log.debug("h2_storage_adapter deleting wallet_id={}", (Object)walletId);
        DataSource dataSource = this.currentDataSource();
        this.ensureSchemaInitialized(dataSource);
        try (Connection conn = dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = conn.prepareStatement("DELETE FROM vouchers WHERE wallet_id = ?");
                try {
                    stmt.setString(1, walletId);
                    int deleted = stmt.executeUpdate();
                    log.info("h2_storage_adapter deleted wallet_id={} vouchers_deleted={}", (Object)walletId, (Object)deleted);
                    boolean bl2 = bl = deleted > 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            log.error("h2_storage_adapter delete_failed wallet_id={} error={}", walletId, e.getMessage(), e);
            throw new WalletStorageException("Failed to delete wallet state from H2 database. Cause: " + e.getMessage() + ". Suggestion: Retry the command or inspect the voucher table for locks.", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean exists(String walletId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getStorageInfo() {
        return "H2[vouchers]";
    }

    private void ensureVouchersTable(DataSource dataSource) {
        try (Connection conn = dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE IF NOT EXISTS vouchers (\n    voucher_id VARCHAR(255) NOT NULL PRIMARY KEY,\n    wallet_id VARCHAR(255) NOT NULL,\n    issuer_id VARCHAR(255) NOT NULL,\n    unit VARCHAR(50) NOT NULL,\n    face_value BIGINT NOT NULL,\n    expires_at BIGINT,\n    memo TEXT,\n    issuer_signature TEXT NOT NULL,\n    issuer_public_key VARCHAR(255) NOT NULL,\n    issued_at TIMESTAMP NOT NULL,\n    status VARCHAR(50) NOT NULL\n)\n");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_vouchers_wallet_id ON vouchers(wallet_id)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_vouchers_status ON vouchers(status)");
            log.debug("h2_storage_adapter vouchers_table_ensured");
        }
        catch (SQLException e) {
            log.error("h2_storage_adapter table_creation_failed error={}", (Object)e.getMessage(), (Object)e);
            throw new WalletStorageException("Failed to create vouchers table in H2 database. Cause: " + e.getMessage() + ". Suggestion: Delete the wallet/voucher files or rerun database migrations.", e);
        }
    }

    private List<StoredVoucher> loadVouchers(Connection conn, String walletId) throws SQLException {
        ArrayList<StoredVoucher> vouchers = new ArrayList<StoredVoucher>();
        try (PreparedStatement stmt = conn.prepareStatement("SELECT voucher_id, issuer_id, unit, face_value, expires_at, memo, issuer_signature, issuer_public_key, issued_at, status FROM vouchers WHERE wallet_id = ? ORDER BY issued_at DESC");){
            stmt.setString(1, walletId);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    Long expiresAt = rs.getObject("expires_at", Long.class);
                    StoredVoucher voucher = new StoredVoucher(rs.getString("voucher_id"), rs.getString("issuer_id"), rs.getString("unit"), rs.getLong("face_value"), expiresAt, rs.getString("memo"), rs.getString("issuer_signature"), rs.getString("issuer_public_key"), rs.getTimestamp("issued_at").toInstant(), rs.getString("status"));
                    vouchers.add(voucher);
                }
            }
        }
        return vouchers;
    }

    private void saveVouchers(Connection conn, String walletId, List<StoredVoucher> vouchers) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement("DELETE FROM vouchers WHERE wallet_id = ?");){
            stmt.setString(1, walletId);
            stmt.executeUpdate();
        }
        if (!vouchers.isEmpty()) {
            stmt = conn.prepareStatement("INSERT INTO vouchers (voucher_id, wallet_id, issuer_id, unit, face_value, expires_at, memo, issuer_signature, issuer_public_key, issued_at, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            try {
                for (StoredVoucher voucher : vouchers) {
                    stmt.setString(1, voucher.voucherId());
                    stmt.setString(2, walletId);
                    stmt.setString(3, voucher.issuerId());
                    stmt.setString(4, voucher.unit());
                    stmt.setLong(5, voucher.faceValue());
                    if (voucher.expiresAt() != null) {
                        stmt.setLong(6, voucher.expiresAt());
                    } else {
                        stmt.setNull(6, -5);
                    }
                    stmt.setString(7, voucher.memo());
                    stmt.setString(8, voucher.issuerSignature());
                    stmt.setString(9, voucher.issuerPublicKey());
                    stmt.setTimestamp(10, Timestamp.from(voucher.issuedAt()));
                    stmt.setString(11, voucher.status());
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }
}

