/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.StoragePaths;

public final class MintRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MintRegistry.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static Map<String, String> cache;

    private MintRegistry() {
    }

    private static Path registryFile() {
        return StoragePaths.walletHome().resolve("mints.json");
    }

    private static synchronized Map<String, String> load() {
        if (cache != null) {
            return cache;
        }
        Path path = MintRegistry.registryFile();
        try {
            cache = !Files.exists(path, new LinkOption[0]) ? new HashMap<String, String>() : MAPPER.readValue(Files.readString(path), new TypeReference<Map<String, String>>(){});
        }
        catch (IOException e) {
            log.warn("mint_registry read_failed path={} reason={} outcome=using_empty_cache", path, e.toString(), e);
            cache = new HashMap<String, String>();
        }
        return cache;
    }

    public static String getMintId(String baseUrl) {
        Map<String, String> map = MintRegistry.load();
        return map.get(baseUrl);
    }

    public static synchronized void putMint(String baseUrl, String mintId) {
        Map<String, String> map = MintRegistry.load();
        map.put(baseUrl, mintId);
        MintRegistry.save(map);
    }

    public static Map<String, String> all() {
        return Collections.unmodifiableMap(MintRegistry.load());
    }

    private static void save(Map<String, String> map) {
        try {
            StoragePaths.ensureDirs();
            Files.writeString(MintRegistry.registryFile(), (CharSequence)MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString(map), new OpenOption[0]);
        }
        catch (IOException e) {
            log.error("mint_registry write_failed path={} reason={} impact=registry_stale", MintRegistry.registryFile(), e.toString(), e);
        }
    }
}

