/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.domain.events.DomainEvent;
import xyz.tcheeric.wallet.core.exception.WalletOperationException;
import xyz.tcheeric.wallet.core.proof.NewProof;
import xyz.tcheeric.wallet.core.validation.CashuUnit;
import xyz.tcheeric.wallet.core.validation.MintUrl;

public interface ReceiveService
extends BalanceService {
    public ImportResult importProofs(ImportRequest var1) throws WalletOperationException;

    public static class ImportResult {
        private final int importedCount;
        private final int duplicateCount;
        private final long importedAmount;
        private final long duplicateAmount;
        private final List<DomainEvent> uncommittedEvents;

        public ImportResult(int importedCount, int duplicateCount, long importedAmount, long duplicateAmount) {
            this(importedCount, duplicateCount, importedAmount, duplicateAmount, Collections.emptyList());
        }

        public ImportResult(int importedCount, int duplicateCount, long importedAmount, long duplicateAmount, List<DomainEvent> uncommittedEvents) {
            if (importedCount < 0) {
                throw new IllegalArgumentException("importedCount must be non-negative");
            }
            if (duplicateCount < 0) {
                throw new IllegalArgumentException("duplicateCount must be non-negative");
            }
            if (importedAmount < 0L) {
                throw new IllegalArgumentException("importedAmount must be non-negative");
            }
            if (duplicateAmount < 0L) {
                throw new IllegalArgumentException("duplicateAmount must be non-negative");
            }
            this.importedCount = importedCount;
            this.duplicateCount = duplicateCount;
            this.importedAmount = importedAmount;
            this.duplicateAmount = duplicateAmount;
            this.uncommittedEvents = new ArrayList<DomainEvent>(uncommittedEvents != null ? uncommittedEvents : Collections.emptyList());
        }

        public int importedCount() {
            return this.importedCount;
        }

        public int duplicateCount() {
            return this.duplicateCount;
        }

        public long importedAmount() {
            return this.importedAmount;
        }

        public long duplicateAmount() {
            return this.duplicateAmount;
        }

        public List<DomainEvent> getUncommittedEvents() {
            return Collections.unmodifiableList(this.uncommittedEvents);
        }

        public long totalAmount() {
            return this.importedAmount + this.duplicateAmount;
        }

        public boolean hasNewProofs() {
            return this.importedCount > 0;
        }
    }

    public record ImportRequest(@MintUrl String mintUrl, @CashuUnit String unit, @NotEmpty List<@Valid @NotNull NewProof> proofs) {
        public ImportRequest(@MintUrl String mintUrl, @CashuUnit String unit, @NotEmpty List<NewProof> proofs) {
            Objects.requireNonNull(mintUrl, "mintUrl");
            Objects.requireNonNull(unit, "unit");
            proofs = List.copyOf((Collection)Objects.requireNonNull(proofs, "proofs"));
            if (proofs.isEmpty()) {
                throw new IllegalArgumentException("proofs must not be empty");
            }
            for (NewProof proof : proofs) {
                Objects.requireNonNull(proof, "proof");
                if (proof.keysetId() != null && !proof.keysetId().isBlank()) continue;
                throw new IllegalArgumentException("proof keysetId must not be blank");
            }
        }
    }
}

