/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.VoucherBackupService;
import xyz.tcheeric.wallet.core.exception.VoucherBackupException;
import xyz.tcheeric.wallet.core.exception.WalletOperationException;
import xyz.tcheeric.wallet.core.nostr.dm.DmCrypto44;
import xyz.tcheeric.wallet.core.nostr.dm.DmMessage;
import xyz.tcheeric.wallet.core.nostr.dm.DmSendRequest;
import xyz.tcheeric.wallet.core.nostr.dm.DmSendResult;
import xyz.tcheeric.wallet.core.nostr.dm.DmService;
import xyz.tcheeric.wallet.core.state.StoredVoucher;

public class VoucherBackupServiceImpl
implements VoucherBackupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoucherBackupServiceImpl.class);
    private static final String VOUCHER_BACKUP_TAG = "voucher-backup";
    private static final TypeReference<List<StoredVoucher>> VOUCHER_LIST_TYPE = new TypeReference<List<StoredVoucher>>(){};
    private final DmService dmService;
    private final DmCrypto44 dmCrypto44;
    private final ObjectMapper objectMapper;

    public VoucherBackupServiceImpl(DmService dmService, DmCrypto44 dmCrypto44) {
        this.dmService = Objects.requireNonNull(dmService, "dmService");
        this.dmCrypto44 = Objects.requireNonNull(dmCrypto44, "dmCrypto44");
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule(new JavaTimeModule());
    }

    @Override
    public String serializeVouchers(List<StoredVoucher> vouchers) {
        Objects.requireNonNull(vouchers, "vouchers");
        try {
            String json = this.objectMapper.writeValueAsString(vouchers);
            log.debug("voucher_backup serialized voucher_count={} json_length={}", (Object)vouchers.size(), (Object)json.length());
            return json;
        }
        catch (JsonProcessingException e) {
            log.error("voucher_backup serialization_failed voucher_count={} error={}", vouchers.size(), e.getMessage(), e);
            throw new RuntimeException("Failed to serialize vouchers: " + e.getMessage(), e);
        }
    }

    @Override
    public List<StoredVoucher> deserializeVouchers(String json) throws WalletOperationException {
        Objects.requireNonNull(json, "json");
        try {
            List<StoredVoucher> vouchers = this.objectMapper.readValue(json, VOUCHER_LIST_TYPE);
            log.debug("voucher_backup deserialized voucher_count={} json_length={}", (Object)vouchers.size(), (Object)json.length());
            return vouchers;
        }
        catch (JsonProcessingException e) {
            log.error("voucher_backup deserialization_failed json_length={} error={}", json.length(), e.getMessage(), e);
            throw VoucherBackupException.forDeserializationFailure(e);
        }
    }

    @Override
    public String encryptBackup(String voucherJson, String senderPrivateKeyHex, String recipientPublicKeyHex) throws WalletOperationException {
        Objects.requireNonNull(voucherJson, "voucherJson");
        Objects.requireNonNull(senderPrivateKeyHex, "senderPrivateKeyHex");
        Objects.requireNonNull(recipientPublicKeyHex, "recipientPublicKeyHex");
        try {
            String encrypted = this.dmCrypto44.encrypt(senderPrivateKeyHex, recipientPublicKeyHex, voucherJson);
            log.debug("voucher_backup encrypted payload_length={} original_length={}", (Object)encrypted.length(), (Object)voucherJson.length());
            return encrypted;
        }
        catch (Exception e) {
            log.error("voucher_backup encryption_failed json_length={} error={}", voucherJson.length(), e.getMessage(), e);
            throw VoucherBackupException.forEncryptionFailure(e);
        }
    }

    @Override
    public String decryptBackup(String encryptedPayload, String selfPrivateKeyHex, String otherPublicKeyHex) throws WalletOperationException {
        Objects.requireNonNull(encryptedPayload, "encryptedPayload");
        Objects.requireNonNull(selfPrivateKeyHex, "selfPrivateKeyHex");
        Objects.requireNonNull(otherPublicKeyHex, "otherPublicKeyHex");
        try {
            String decrypted = this.dmCrypto44.decrypt(selfPrivateKeyHex, otherPublicKeyHex, encryptedPayload);
            log.debug("voucher_backup decrypted payload_length={} decrypted_length={}", (Object)encryptedPayload.length(), (Object)decrypted.length());
            return decrypted;
        }
        catch (Exception e) {
            log.error("voucher_backup decryption_failed payload_length={} error={}", encryptedPayload.length(), e.getMessage(), e);
            throw VoucherBackupException.forDecryptionFailure(e);
        }
    }

    @Override
    public String publishBackup(String encryptedPayload, String ownerPublicKeyHex) throws WalletOperationException {
        Objects.requireNonNull(encryptedPayload, "encryptedPayload");
        Objects.requireNonNull(ownerPublicKeyHex, "ownerPublicKeyHex");
        try {
            DmSendRequest request = DmSendRequest.now(ownerPublicKeyHex, encryptedPayload);
            log.info("voucher_backup publishing recipient={} payload_length={}", (Object)ownerPublicKeyHex, (Object)encryptedPayload.length());
            DmSendResult result = this.dmService.send(request);
            if (result.eventId() == null || result.eventId().isEmpty()) {
                throw VoucherBackupException.forPublishFailure("No event ID returned from relays", true);
            }
            log.info("voucher_backup published event_id={} relays_acked={}", (Object)result.eventId(), (Object)result.relaysAcked().size());
            return result.eventId();
        }
        catch (VoucherBackupException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("voucher_backup publish_failed owner_pubkey={} error={}", ownerPublicKeyHex, e.getMessage(), e);
            throw VoucherBackupException.forPublishFailure(e.getMessage(), true, e);
        }
    }

    @Override
    public List<String> queryBackups(String ownerPublicKeyHex, int limit) throws WalletOperationException {
        Objects.requireNonNull(ownerPublicKeyHex, "ownerPublicKeyHex");
        try {
            log.info("voucher_backup querying_backups owner_pubkey={} limit={}", (Object)ownerPublicKeyHex, (Object)limit);
            DmService.DmQuery query = new DmService.DmQuery(null, null, limit, List.of(), List.of(ownerPublicKeyHex));
            List<DmMessage> messages = this.dmService.list(query);
            List<String> encryptedBackups = messages.stream().map(DmMessage::content).filter(content -> content != null && !content.isEmpty()).toList();
            log.info("voucher_backup query_complete backup_count={} limit={}", (Object)encryptedBackups.size(), (Object)limit);
            return encryptedBackups;
        }
        catch (Exception e) {
            log.error("voucher_backup query_failed owner_pubkey={} error={}", ownerPublicKeyHex, e.getMessage(), e);
            throw VoucherBackupException.forQueryFailure(ownerPublicKeyHex, e);
        }
    }
}

