/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core;

import java.nio.file.Path;

public class WalletDatabaseConfig {
    private final String jdbcUrl;
    private final String user;
    private final String pass;

    private WalletDatabaseConfig(String jdbcUrl, String user, String pass) {
        this.jdbcUrl = jdbcUrl;
        this.user = user;
        this.pass = pass;
    }

    public static WalletDatabaseConfig forPath(Path home) {
        String url = "jdbc:h2:file:" + home.resolve("wallet").toString() + ";DB_CLOSE_DELAY=-1;AUTO_SERVER=TRUE";
        return new WalletDatabaseConfig(url, "sa", "");
    }

    public static WalletDatabaseConfig inMemory() {
        return new WalletDatabaseConfig("jdbc:h2:mem:wallet_test;DB_CLOSE_DELAY=-1", "sa", "");
    }

    public static WalletDatabaseConfig fromJdbcUrl(String jdbcUrl) {
        return new WalletDatabaseConfig(jdbcUrl, "sa", "");
    }

    public static WalletDatabaseConfig of(String jdbcUrl, String username, String password) {
        return new WalletDatabaseConfig(jdbcUrl, username, password);
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUser() {
        return this.user;
    }

    public String getPass() {
        return this.pass;
    }
}

