/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core;

import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import xyz.tcheeric.wallet.core.BalanceService;
import xyz.tcheeric.wallet.core.WalletServiceFactory;

public final class WalletServices {
    private WalletServices() {
    }

    public static BalanceService createDefault() {
        return WalletServices.createDefault(System.getenv());
    }

    public static BalanceService createDefault(Map<String, String> env) {
        ServiceLoader<WalletServiceFactory> loader = ServiceLoader.load(WalletServiceFactory.class);
        for (WalletServiceFactory factory2 : loader) {
            Optional<BalanceService> service = factory2.create(env);
            if (!service.isPresent()) continue;
            return service.get();
        }
        throw new IllegalStateException("No WalletServiceFactory found for environment");
    }
}

