/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.api;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.entities.rest.GetActiveKeySetsResponse;
import xyz.tcheeric.cashu.entities.rest.GetKeySetsResponse;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteBolt11Response;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintResponse;
import xyz.tcheeric.cashu.entities.rest.PostSwapResponse;
import xyz.tcheeric.wallet.core.api.MintApi;

public class MintApiMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MintApiMapper.class);
    private final ObjectMapper mapper;

    public MintApiMapper() {
        this(new ObjectMapper());
    }

    public MintApiMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public String write(Object value) throws IOException {
        return this.mapper.writeValueAsString(value);
    }

    public MintApi.MintInfo parseMintInfo(String base, String body2) throws IOException {
        List<String> units = this.parseUnits(body2);
        List<String> mintMethods = this.parseMethods(body2, "mint_methods", "mint");
        List<String> meltMethods = this.parseMethods(body2, "melt_methods", "melt");
        if (units.isEmpty() || mintMethods.isEmpty() && meltMethods.isEmpty()) {
            try {
                JsonNode root = this.mapper.readTree(body2);
                JsonNode nuts = root.get("nuts");
                if (nuts != null && nuts.isObject()) {
                    JsonNode nut5;
                    HashSet<String> unitSet = new HashSet<String>();
                    LinkedHashSet<String> mintSet = new LinkedHashSet<String>();
                    LinkedHashSet<String> meltSet = new LinkedHashSet<String>();
                    JsonNode nut4 = nuts.get("4");
                    if (nut4 != null && nut4.has("methods")) {
                        for (JsonNode m : nut4.get("methods")) {
                            if (m.hasNonNull("unit")) {
                                unitSet.add(m.get("unit").asText());
                            }
                            if (!m.hasNonNull("method")) continue;
                            mintSet.add(m.get("method").asText());
                        }
                    }
                    if ((nut5 = nuts.get("5")) != null && nut5.has("methods")) {
                        for (JsonNode m : nut5.get("methods")) {
                            if (m.hasNonNull("unit")) {
                                unitSet.add(m.get("unit").asText());
                            }
                            if (!m.hasNonNull("method")) continue;
                            meltSet.add(m.get("method").asText());
                        }
                    }
                    if (units.isEmpty()) {
                        units = new ArrayList<String>(unitSet);
                    }
                    if (mintMethods.isEmpty()) {
                        mintMethods = new ArrayList<String>(mintSet);
                    }
                    if (meltMethods.isEmpty()) {
                        meltMethods = new ArrayList<String>(meltSet);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        log.info("mint_api_mapper mint_info_parsed base_url={} units={} mint_methods={} melt_methods={}", base, units, mintMethods, meltMethods);
        return new MintApi.MintInfo(base, units, Map.of(), mintMethods, meltMethods);
    }

    public String pickMethodForUnit(String body2, boolean forMint, String unit) throws IOException {
        String nutKey;
        JsonNode nut;
        if (unit == null || unit.isBlank()) {
            return null;
        }
        JsonNode root = this.mapper.readTree(body2);
        JsonNode nuts = root.get("nuts");
        if (nuts != null && nuts.isObject() && (nut = nuts.get(nutKey = forMint ? "4" : "5")) != null && nut.has("methods")) {
            for (JsonNode m : nut.get("methods")) {
                String mUnit = m.hasNonNull("unit") ? m.get("unit").asText() : null;
                String method = m.hasNonNull("method") ? m.get("method").asText() : null;
                if (method == null || mUnit == null || !unit.equalsIgnoreCase(mUnit)) continue;
                return method;
            }
        }
        MintApi.MintInfo info = this.parseMintInfo("", body2);
        List<String> methods = forMint ? info.mintMethods() : info.meltMethods();
        return methods != null && !methods.isEmpty() ? methods.get(0) : null;
    }

    public MintApi.MintQuote parseMintQuote(String unit, long amount, String resp) throws IOException {
        PostMintQuoteResponse respObj = this.mapper.readValue(resp, PostMintQuoteResponse.class);
        String quoteId = respObj.getQuoteId();
        log.info("mint_api_mapper mint_quote_parsed quote_id={} amount={} unit={} outcome=parsed", quoteId, amount, unit);
        return new MintApi.MintQuote(quoteId, amount, unit, resp);
    }

    public PostMintQuoteResponse parseMintQuoteStatus(String resp) throws IOException {
        return this.mapper.readValue(resp, PostMintQuoteResponse.class);
    }

    public boolean isPaid(String resp) throws IOException {
        JsonNode root = this.mapper.readTree(resp);
        JsonNode paid = root.get("paid");
        return paid != null && paid.isBoolean() && paid.asBoolean();
    }

    public MintApi.MeltQuote parseMeltQuote(String unit, long amount, String resp) throws IOException {
        PostMeltQuoteBolt11Response respObj = this.mapper.readValue(resp, PostMeltQuoteBolt11Response.class);
        String quoteId = respObj.getQuoteId();
        long feeReserve = respObj.getFeeReserve();
        log.info("mint_api_mapper melt_quote_parsed quote_id={} amount={} unit={} fee_reserve={} outcome=parsed", quoteId, amount, unit, feeReserve);
        return new MintApi.MeltQuote(quoteId, amount, unit, feeReserve, resp);
    }

    public PostMeltQuoteResponse parseMeltQuoteStatus(String resp) throws IOException {
        return this.mapper.readValue(resp, PostMeltQuoteResponse.class);
    }

    public GetActiveKeySetsResponse parseActiveKeysets(String body2) throws IOException {
        try {
            GetActiveKeySetsResponse out = this.mapper.readValue(body2, GetActiveKeySetsResponse.class);
            log.info("mint_api_mapper active_keysets_parsed outcome=parsed");
            return out;
        }
        catch (Exception primary) {
            JsonNode root = this.mapper.readTree(body2);
            JsonNode keysets = root.get("keysets");
            if (keysets != null && keysets.isArray()) {
                ObjectNode obj = this.mapper.createObjectNode();
                obj.set("activeKeySets", keysets);
                GetActiveKeySetsResponse out = this.mapper.treeToValue((TreeNode)obj, GetActiveKeySetsResponse.class);
                log.info("mint_api_mapper active_keysets_parsed outcome=remapped");
                return out;
            }
            if (primary instanceof IOException) {
                IOException ioe = (IOException)primary;
                throw ioe;
            }
            throw new IOException("Failed to parse active key sets", primary);
        }
    }

    public GetKeySetsResponse parseKeyset(String body2) throws IOException {
        GetKeySetsResponse out = this.mapper.readValue(body2, GetKeySetsResponse.class);
        log.info("mint_api_mapper keyset_parsed outcome=parsed");
        return out;
    }

    public PostMintResponse parseMintResponse(String resp) throws IOException {
        PostMintResponse out = this.mapper.readValue(resp, PostMintResponse.class);
        log.info("mint_api_mapper mint_response_parsed outcome=parsed");
        return out;
    }

    public PostMeltResponse parseMeltResponse(String resp) throws IOException {
        PostMeltResponse out = this.mapper.readValue(resp, PostMeltResponse.class);
        log.info("mint_api_mapper melt_response_parsed outcome=parsed");
        return out;
    }

    public PostSwapResponse parseSwapResponse(String resp) throws IOException {
        PostSwapResponse out = this.mapper.readValue(resp, PostSwapResponse.class);
        log.info("mint_api_mapper swap_response_parsed outcome=parsed");
        return out;
    }

    public PostCheckStateResponse parseCheckResponse(String resp) throws IOException {
        PostCheckStateResponse out = this.mapper.readValue(resp, PostCheckStateResponse.class);
        log.info("mint_api_mapper check_response_parsed outcome=parsed");
        return out;
    }

    private List<String> parseUnits(String body2) throws IOException {
        List<String> units = this.readStringArray(body2, "units");
        if (units.isEmpty()) {
            units = this.readStringArray(body2, "unit");
        }
        return units;
    }

    private List<String> parseMethods(String body2, String arrayField, String objectField) throws IOException {
        JsonNode arr;
        List<String> methods = this.readStringArray(body2, arrayField);
        if (!methods.isEmpty()) {
            return methods;
        }
        JsonNode root = this.mapper.readTree(body2);
        JsonNode methodsNode = root.get("methods");
        if (methodsNode != null && methodsNode.isObject() && (arr = methodsNode.get(objectField)) != null && arr.isArray()) {
            ArrayList<String> out = new ArrayList<String>();
            for (JsonNode el : arr) {
                if (!el.isTextual()) continue;
                out.add(el.asText());
            }
            return out;
        }
        return List.of();
    }

    private List<String> readStringArray(String json, String fieldName) throws IOException {
        ArrayList<String> out = new ArrayList<String>();
        JsonNode arr = this.mapper.readTree(json).get(fieldName);
        if (arr != null && arr.isArray()) {
            for (JsonNode el : arr) {
                if (!el.isTextual()) continue;
                out.add(el.asText());
            }
        }
        return out;
    }
}

