/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.api;

import java.util.Map;
import xyz.tcheeric.wallet.core.api.MintApiException;

public final class MintInvoiceNotPaidException
extends MintApiException {
    private static final String SUGGESTION = "Wait for the Lightning invoice to settle, then retry the mint command or request a new quote";

    public MintInvoiceNotPaidException(String mintUrl, String quoteId, String unit, String reason, Throwable cause) {
        super(MintInvoiceNotPaidException.formatMessage(quoteId, reason), mintUrl, Map.of("quoteId", quoteId, "unit", unit), cause);
    }

    private static String formatMessage(String quoteId, String reason) {
        String why = reason == null || reason.isBlank() ? "Mint reported that the Lightning invoice is not paid yet" : reason;
        return String.format("Mint refused to mint tokens for quoteId=%s. %s. Suggestion: %s", quoteId, why, SUGGESTION);
    }
}

