/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.api.adapter;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

public class MintApiLoggingInterceptor
implements ClientHttpRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MintApiLoggingInterceptor.class);
    private final boolean logRequestBody;
    private final boolean logResponseBody;
    private static final int MAX_BODY_LOG_SIZE = 1024;

    @Override
    public ClientHttpResponse intercept(HttpRequest request, byte[] body2, ClientHttpRequestExecution execution) throws IOException {
        String requestId = UUID.randomUUID().toString();
        long startNanos = System.nanoTime();
        this.logRequest(requestId, request, body2);
        ClientHttpResponse response = null;
        try {
            response = execution.execute(request, body2);
            ClientHttpResponse responseForLogging = this.prepareResponseForLogging(response);
            this.logResponse(requestId, responseForLogging, startNanos);
            return responseForLogging;
        }
        catch (IOException e) {
            this.logRequestFailure(requestId, request, e, startNanos);
            throw e;
        }
    }

    private ClientHttpResponse prepareResponseForLogging(ClientHttpResponse response) {
        CachedBodyClientHttpResponse cachedBodyClientHttpResponse;
        block9: {
            if (!this.logResponseBody || !log.isDebugEnabled()) {
                return response;
            }
            InputStream responseStream = response.getBody();
            try {
                byte[] bufferedBody = StreamUtils.copyToByteArray(responseStream);
                cachedBodyClientHttpResponse = new CachedBodyClientHttpResponse(response, bufferedBody);
                if (responseStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (responseStream != null) {
                        try {
                            responseStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.debug("mint_api_logging_interceptor response_buffering_failed reason={}", (Object)e.toString());
                    return response;
                }
            }
            responseStream.close();
        }
        return cachedBodyClientHttpResponse;
    }

    private void logRequest(String requestId, HttpRequest request, byte[] body2) {
        int bodyLength;
        if (!log.isDebugEnabled()) {
            return;
        }
        String method = request.getMethod().name();
        String url = request.getURI().toString();
        int n = bodyLength = body2 != null ? body2.length : 0;
        if (this.logRequestBody && bodyLength > 0) {
            String bodyString = new String(body2, StandardCharsets.UTF_8);
            log.debug("mint_api_request request_id={} method={} url={} body_bytes={} body='{}'", requestId, method, url, bodyLength, this.truncateForLog(bodyString));
        } else {
            log.debug("mint_api_request request_id={} method={} url={} body_bytes={}", requestId, method, url, bodyLength);
        }
    }

    private void logResponse(String requestId, ClientHttpResponse response, long startNanos) {
        if (!log.isDebugEnabled()) {
            return;
        }
        try {
            int statusCode = response.getRawStatusCode();
            String statusText = response.getStatusText();
            long durationMs = (System.nanoTime() - startNanos) / 1000000L;
            if (this.logResponseBody && response instanceof CachedBodyClientHttpResponse) {
                String body2 = this.readResponseBody(response);
                log.debug("mint_api_response request_id={} status={} status_text='{}' duration_ms={} body='{}'", requestId, statusCode, statusText, durationMs, this.truncateForLog(body2));
            } else if (this.logResponseBody) {
                log.debug("mint_api_response request_id={} status={} status_text='{}' duration_ms={} body='{}'", requestId, statusCode, statusText, durationMs, "(not logged: buffering failed)");
            } else {
                log.debug("mint_api_response request_id={} status={} status_text='{}' duration_ms={}", requestId, statusCode, statusText, durationMs);
            }
        }
        catch (IOException e) {
            log.warn("mint_api_logging_interceptor failed_to_log_response request_id={} reason={}", (Object)requestId, (Object)e.toString());
        }
    }

    private void logRequestFailure(String requestId, HttpRequest request, IOException error, long startNanos) {
        if (!log.isErrorEnabled()) {
            return;
        }
        String method = request.getMethod().name();
        String url = request.getURI().toString();
        long durationMs = (System.nanoTime() - startNanos) / 1000000L;
        log.error("mint_api_request_failed request_id={} method={} url={} duration_ms={} error={}", requestId, method, url, durationMs, error.toString());
    }

    private String readResponseBody(ClientHttpResponse response) throws IOException {
        String string;
        BufferedReader reader = new BufferedReader(new InputStreamReader(response.getBody(), StandardCharsets.UTF_8));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return "(failed to read: " + e.getMessage() + ")";
            }
        }
        reader.close();
        return string;
    }

    private String truncateForLog(String body2) {
        if (body2 == null) {
            return "(null)";
        }
        if (body2.isEmpty()) {
            return "(empty)";
        }
        if (body2.length() <= 1024) {
            return body2;
        }
        return body2.substring(0, 1024) + "... (truncated, total " + body2.length() + " chars)";
    }

    @Generated
    public MintApiLoggingInterceptor(boolean logRequestBody, boolean logResponseBody) {
        this.logRequestBody = logRequestBody;
        this.logResponseBody = logResponseBody;
    }

    private static final class CachedBodyClientHttpResponse
    implements ClientHttpResponse {
        private final ClientHttpResponse delegate;
        private final byte[] body;

        private CachedBodyClientHttpResponse(ClientHttpResponse delegate, byte[] body2) {
            this.delegate = delegate;
            this.body = body2 != null ? body2 : new byte[]{};
        }

        @Override
        public HttpStatusCode getStatusCode() throws IOException {
            return this.delegate.getStatusCode();
        }

        @Override
        public int getRawStatusCode() throws IOException {
            return this.delegate.getRawStatusCode();
        }

        @Override
        public String getStatusText() throws IOException {
            return this.delegate.getStatusText();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public InputStream getBody() {
            return new ByteArrayInputStream(this.body);
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.delegate.getHeaders();
        }
    }
}

