/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.api.adapter;

import java.time.Duration;
import lombok.Generated;

public final class RestTemplateConfig {
    public static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(5L);
    public static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(30L);
    private final Duration connectTimeout;
    private final Duration readTimeout;
    private final boolean enableLogging;
    private final boolean logRequestBody;
    private final boolean logResponseBody;

    public static RestTemplateConfig defaultConfig() {
        return RestTemplateConfig.builder().build();
    }

    public static RestTemplateConfig testConfig() {
        return RestTemplateConfig.builder().connectTimeout(Duration.ofSeconds(1L)).readTimeout(Duration.ofSeconds(5L)).enableLogging(true).logRequestBody(true).logResponseBody(true).build();
    }

    public static RestTemplateConfig debugConfig() {
        return RestTemplateConfig.builder().connectTimeout(Duration.ofSeconds(10L)).readTimeout(Duration.ofSeconds(60L)).enableLogging(true).logRequestBody(true).logResponseBody(true).build();
    }

    public void validate() {
        if (this.connectTimeout == null || this.connectTimeout.isNegative() || this.connectTimeout.isZero()) {
            throw new IllegalStateException("connectTimeout must be positive: " + String.valueOf(this.connectTimeout));
        }
        if (this.readTimeout == null || this.readTimeout.isNegative() || this.readTimeout.isZero()) {
            throw new IllegalStateException("readTimeout must be positive: " + String.valueOf(this.readTimeout));
        }
        if (this.connectTimeout.compareTo(Duration.ofMinutes(1L)) > 0) {
            throw new IllegalStateException("connectTimeout too long (>1min): " + String.valueOf(this.connectTimeout));
        }
        if (this.readTimeout.compareTo(Duration.ofMinutes(5L)) > 0) {
            throw new IllegalStateException("readTimeout too long (>5min): " + String.valueOf(this.readTimeout));
        }
    }

    @Generated
    private static Duration $default$connectTimeout() {
        return DEFAULT_CONNECT_TIMEOUT;
    }

    @Generated
    private static Duration $default$readTimeout() {
        return DEFAULT_READ_TIMEOUT;
    }

    @Generated
    private static boolean $default$enableLogging() {
        return true;
    }

    @Generated
    private static boolean $default$logRequestBody() {
        return false;
    }

    @Generated
    private static boolean $default$logResponseBody() {
        return false;
    }

    @Generated
    RestTemplateConfig(Duration connectTimeout, Duration readTimeout, boolean enableLogging, boolean logRequestBody, boolean logResponseBody) {
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.enableLogging = enableLogging;
        this.logRequestBody = logRequestBody;
        this.logResponseBody = logResponseBody;
    }

    @Generated
    public static RestTemplateConfigBuilder builder() {
        return new RestTemplateConfigBuilder();
    }

    @Generated
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Generated
    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public boolean isEnableLogging() {
        return this.enableLogging;
    }

    @Generated
    public boolean isLogRequestBody() {
        return this.logRequestBody;
    }

    @Generated
    public boolean isLogResponseBody() {
        return this.logResponseBody;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestTemplateConfig)) {
            return false;
        }
        RestTemplateConfig other = (RestTemplateConfig)o;
        if (this.isEnableLogging() != other.isEnableLogging()) {
            return false;
        }
        if (this.isLogRequestBody() != other.isLogRequestBody()) {
            return false;
        }
        if (this.isLogResponseBody() != other.isLogResponseBody()) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$readTimeout = this.getReadTimeout();
        Duration other$readTimeout = other.getReadTimeout();
        return !(this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnableLogging() ? 79 : 97);
        result = result * 59 + (this.isLogRequestBody() ? 79 : 97);
        result = result * 59 + (this.isLogResponseBody() ? 79 : 97);
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RestTemplateConfig(connectTimeout=" + String.valueOf(this.getConnectTimeout()) + ", readTimeout=" + String.valueOf(this.getReadTimeout()) + ", enableLogging=" + this.isEnableLogging() + ", logRequestBody=" + this.isLogRequestBody() + ", logResponseBody=" + this.isLogResponseBody() + ")";
    }

    @Generated
    public static class RestTemplateConfigBuilder {
        @Generated
        private boolean connectTimeout$set;
        @Generated
        private Duration connectTimeout$value;
        @Generated
        private boolean readTimeout$set;
        @Generated
        private Duration readTimeout$value;
        @Generated
        private boolean enableLogging$set;
        @Generated
        private boolean enableLogging$value;
        @Generated
        private boolean logRequestBody$set;
        @Generated
        private boolean logRequestBody$value;
        @Generated
        private boolean logResponseBody$set;
        @Generated
        private boolean logResponseBody$value;

        @Generated
        RestTemplateConfigBuilder() {
        }

        @Generated
        public RestTemplateConfigBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout$value = connectTimeout;
            this.connectTimeout$set = true;
            return this;
        }

        @Generated
        public RestTemplateConfigBuilder readTimeout(Duration readTimeout) {
            this.readTimeout$value = readTimeout;
            this.readTimeout$set = true;
            return this;
        }

        @Generated
        public RestTemplateConfigBuilder enableLogging(boolean enableLogging) {
            this.enableLogging$value = enableLogging;
            this.enableLogging$set = true;
            return this;
        }

        @Generated
        public RestTemplateConfigBuilder logRequestBody(boolean logRequestBody) {
            this.logRequestBody$value = logRequestBody;
            this.logRequestBody$set = true;
            return this;
        }

        @Generated
        public RestTemplateConfigBuilder logResponseBody(boolean logResponseBody) {
            this.logResponseBody$value = logResponseBody;
            this.logResponseBody$set = true;
            return this;
        }

        @Generated
        public RestTemplateConfig build() {
            Duration connectTimeout$value = this.connectTimeout$value;
            if (!this.connectTimeout$set) {
                connectTimeout$value = RestTemplateConfig.$default$connectTimeout();
            }
            Duration readTimeout$value = this.readTimeout$value;
            if (!this.readTimeout$set) {
                readTimeout$value = RestTemplateConfig.$default$readTimeout();
            }
            boolean enableLogging$value = this.enableLogging$value;
            if (!this.enableLogging$set) {
                enableLogging$value = RestTemplateConfig.$default$enableLogging();
            }
            boolean logRequestBody$value = this.logRequestBody$value;
            if (!this.logRequestBody$set) {
                logRequestBody$value = RestTemplateConfig.$default$logRequestBody();
            }
            boolean logResponseBody$value = this.logResponseBody$value;
            if (!this.logResponseBody$set) {
                logResponseBody$value = RestTemplateConfig.$default$logResponseBody();
            }
            return new RestTemplateConfig(connectTimeout$value, readTimeout$value, enableLogging$value, logRequestBody$value, logResponseBody$value);
        }

        @Generated
        public String toString() {
            return "RestTemplateConfig.RestTemplateConfigBuilder(connectTimeout$value=" + String.valueOf(this.connectTimeout$value) + ", readTimeout$value=" + String.valueOf(this.readTimeout$value) + ", enableLogging$value=" + this.enableLogging$value + ", logRequestBody$value=" + this.logRequestBody$value + ", logResponseBody$value=" + this.logResponseBody$value + ")";
        }
    }
}

