/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.api.adapter;

import java.time.Duration;
import java.util.ArrayList;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import xyz.tcheeric.wallet.core.api.adapter.MintApiErrorHandler;
import xyz.tcheeric.wallet.core.api.adapter.MintApiLoggingInterceptor;
import xyz.tcheeric.wallet.core.api.adapter.RestTemplateConfig;

public final class RestTemplateFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestTemplateFactory.class);

    private RestTemplateFactory() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static RestTemplate create() {
        return RestTemplateFactory.create(RestTemplateConfig.defaultConfig());
    }

    public static RestTemplate createFromSystemProperties() {
        RestTemplateConfig config = RestTemplateFactory.loadConfigFromSystemProperties();
        return RestTemplateFactory.create(config);
    }

    private static RestTemplateConfig loadConfigFromSystemProperties() {
        int connectTimeout = RestTemplateFactory.getIntProperty("mint.api.connect-timeout", "MINT_API_CONNECT_TIMEOUT", (int)RestTemplateConfig.DEFAULT_CONNECT_TIMEOUT.toMillis());
        int readTimeout = RestTemplateFactory.getIntProperty("mint.api.read-timeout", "MINT_API_READ_TIMEOUT", (int)RestTemplateConfig.DEFAULT_READ_TIMEOUT.toMillis());
        boolean loggingEnabled = RestTemplateFactory.getBooleanProperty("mint.api.logging.enabled", "MINT_API_LOGGING_ENABLED", true);
        boolean logRequestBody = RestTemplateFactory.getBooleanProperty("mint.api.logging.log-request-body", "MINT_API_LOGGING_LOG_REQUEST_BODY", false);
        boolean logResponseBody = RestTemplateFactory.getBooleanProperty("mint.api.logging.log-response-body", "MINT_API_LOGGING_LOG_RESPONSE_BODY", false);
        return RestTemplateConfig.builder().connectTimeout(Duration.ofMillis(connectTimeout)).readTimeout(Duration.ofMillis(readTimeout)).enableLogging(loggingEnabled).logRequestBody(logRequestBody).logResponseBody(logResponseBody).build();
    }

    private static int getIntProperty(String sysProp, String envVar, int defaultValue) {
        String envValue;
        String sysPropValue = System.getProperty(sysProp);
        if (sysPropValue != null) {
            try {
                return Integer.parseInt(sysPropValue);
            }
            catch (NumberFormatException e) {
                log.warn("rest_template_factory invalid_int_property property={} value='{}' using_default={}", sysProp, sysPropValue, defaultValue);
            }
        }
        if ((envValue = System.getenv(envVar)) != null) {
            try {
                return Integer.parseInt(envValue);
            }
            catch (NumberFormatException e) {
                log.warn("rest_template_factory invalid_int_env env={} value='{}' using_default={}", envVar, envValue, defaultValue);
            }
        }
        return defaultValue;
    }

    private static boolean getBooleanProperty(String sysProp, String envVar, boolean defaultValue) {
        String sysPropValue = System.getProperty(sysProp);
        if (sysPropValue != null) {
            return Boolean.parseBoolean(sysPropValue);
        }
        String envValue = System.getenv(envVar);
        if (envValue != null) {
            return Boolean.parseBoolean(envValue);
        }
        return defaultValue;
    }

    public static RestTemplate create(@NonNull RestTemplateConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        config.validate();
        log.debug("rest_template_factory creating_rest_template connect_timeout_ms={} read_timeout_ms={} logging_enabled={}", config.getConnectTimeout().toMillis(), config.getReadTimeout().toMillis(), config.isEnableLogging());
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setConnectTimeout((int)config.getConnectTimeout().toMillis());
        requestFactory.setReadTimeout((int)config.getReadTimeout().toMillis());
        RestTemplate restTemplate = new RestTemplate(requestFactory);
        restTemplate.setErrorHandler(new MintApiErrorHandler());
        if (config.isEnableLogging()) {
            ArrayList<ClientHttpRequestInterceptor> interceptors = new ArrayList<ClientHttpRequestInterceptor>();
            interceptors.add(new MintApiLoggingInterceptor(config.isLogRequestBody(), config.isLogResponseBody()));
            restTemplate.setInterceptors(interceptors);
        }
        log.debug("rest_template_factory created_rest_template error_handler={} interceptors={}", (Object)restTemplate.getErrorHandler().getClass().getSimpleName(), (Object)restTemplate.getInterceptors().size());
        return restTemplate;
    }

    public static RestTemplate createForTest() {
        return RestTemplateFactory.create(RestTemplateConfig.testConfig());
    }

    public static RestTemplate createForDebug() {
        return RestTemplateFactory.create(RestTemplateConfig.debugConfig());
    }

    public static RestTemplate createWithConnectionPooling(@NonNull RestTemplateConfig config) {
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
        log.warn("rest_template_factory connection_pooling_not_implemented action='Add Apache HttpClient dependency to enable pooling'");
        return RestTemplateFactory.create(config);
    }
}

