/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.application;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import xyz.tcheeric.wallet.core.ReceiveService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.domain.events.DomainEvent;
import xyz.tcheeric.wallet.core.exception.WalletOperationException;

public interface ReceiveUseCase {
    public ImportTokenResult importToken(ImportTokenCommand var1) throws WalletOperationException;

    public ListenForTransfersResult listenForTransfers(ListenForTransfersCommand var1);

    public static enum ProcessingStatus {
        IMPORTED,
        DUPLICATE_ONLY,
        FAILED,
        IGNORED;

    }

    public record TransferProcessingResult(String eventId, String sender, String mintUrl, String unit, ReceiveService.ImportResult importResult, ProcessingStatus status, boolean ackPublished, String errorMessage, String ackErrorMessage, List<DomainEvent> events) {
        public TransferProcessingResult {
            Objects.requireNonNull(eventId, "eventId");
            Objects.requireNonNull(status, "status");
            events = events == null ? List.of() : Collections.unmodifiableList(new ArrayList<DomainEvent>(events));
        }

        public boolean wasImported() {
            return this.status == ProcessingStatus.IMPORTED || this.status == ProcessingStatus.DUPLICATE_ONLY;
        }
    }

    public record ListenForTransfersResult(List<TransferProcessingResult> events, List<DomainEvent> publishedEvents) {
        public ListenForTransfersResult {
            events = events == null ? List.of() : Collections.unmodifiableList(new ArrayList<TransferProcessingResult>(events));
            publishedEvents = publishedEvents == null ? List.of() : Collections.unmodifiableList(new ArrayList<DomainEvent>(publishedEvents));
        }

        public long successCount() {
            return this.events.stream().filter(TransferProcessingResult::wasImported).count();
        }
    }

    public record ListenForTransfersCommand(WalletConfig walletConfig, int durationSeconds, List<String> relayUrls) {
        public ListenForTransfersCommand {
            Objects.requireNonNull(walletConfig, "walletConfig");
            if (durationSeconds <= 0) {
                throw new IllegalArgumentException("durationSeconds must be positive");
            }
            relayUrls = relayUrls == null ? List.of() : List.copyOf(relayUrls);
        }

        public boolean hasRelayOverride() {
            return !this.relayUrls.isEmpty();
        }
    }

    public record ImportTokenResult(String mintUrl, String unit, ReceiveService.ImportResult importResult, boolean fromEvent, String sourceEventId, boolean ackPublished, String ackErrorMessage, List<DomainEvent> events) {
        public ImportTokenResult {
            Objects.requireNonNull(mintUrl, "mintUrl");
            Objects.requireNonNull(unit, "unit");
            if (fromEvent && (sourceEventId == null || sourceEventId.isBlank())) {
                throw new IllegalArgumentException("sourceEventId required for event imports");
            }
            events = events == null ? List.of() : Collections.unmodifiableList(new ArrayList<DomainEvent>(events));
        }

        public boolean hasNewProofs() {
            return this.importResult != null && this.importResult.hasNewProofs();
        }
    }

    public record ImportTokenCommand(WalletConfig walletConfig, String token) {
        public ImportTokenCommand {
            Objects.requireNonNull(walletConfig, "walletConfig");
            Objects.requireNonNull(token, "token");
            if (token.isBlank()) {
                throw new IllegalArgumentException("token must not be blank");
            }
        }
    }
}

